#
# ginvoke: a programmable launcher for GTK+
# Copyright (C) 2011 Thomas Lee
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os

import gtk

class CommandStore(gtk.ListStore):
    TYPE_KEYWORD = 1
    TYPE_EXECUTABLE = 2

    def __init__(self, commands):
        gtk.ListStore.__init__(self, str, int)

        self.commands = commands
        self.loadcommands()
        self.loadpath()

    def loadcommands(self):
        for command in self.commands:
            self.append((command, self.TYPE_KEYWORD))

    def loadpath(self):
        for dirname in os.environ["PATH"].split(os.path.pathsep):
            for filename in os.listdir(dirname):
                if filename in ("."):
                    continue
                self.append((filename, self.TYPE_EXECUTABLE))

