import gtk

from .common import get_icon_pixbuf, ICONDIR

import appindicator

def StatusIcon(title):
    ind = appindicator.Indicator("ginvoke", "ginvoke", appindicator.CATEGORY_APPLICATION_STATUS, ICONDIR)
    ind.set_status(appindicator.STATUS_ACTIVE)
    return ind

class PopupMenu(gtk.Menu):
    def __init__(self):
        gtk.Menu.__init__(self)

        self.quit_menuitem = gtk.MenuItem("_Quit")
        self.quit_menuitem.show_all()
        self.append(self.quit_menuitem)

    def onquit(self, handler):
        self.quit_menuitem.connect("activate", handler)

