import gtk

from .common import get_icon_pixbuf
from .entry import Entry

class Window(gtk.Window):
    def __init__(self, engine):
        gtk.Window.__init__(self)

        self.engine = engine

        self.set_icon(get_icon_pixbuf())

        self.set_position(gtk.WIN_POS_CENTER)
        self.set_decorated(False)
        self.set_has_frame(False)
        self.set_keep_above(True)
        self.set_skip_taskbar_hint(False)
        self.set_focus_on_map(True)

        self.entry = Entry(engine)
        self.entry.connect("key-release-event", self.entry_keyrelease)
        self.entry.connect("key-press-event", self.entry_keypress)
        self.entry.connect("activate", self.entry_activate)

        self.connect("show", self.self_show)

        hbox = gtk.HBox(False, 0)
        hbox.pack_start(self.entry, True, True, 5)

        vbox = gtk.VBox(False, 0)
        vbox.pack_start(hbox, True, True, 5)

        vbox.show_all()

        self.add(vbox)

        self.seen_esc_press = False
        self.escape_key = gtk.gdk.keyval_from_name("Escape")

    def self_show(self, widget):
        self.get_window().focus()
        self.entry.select_region(0, -1)
        # XXX this hack forces the window to grab keyboard focus...
        self.entry.grab_focus()

    def entry_activate(self, widget):
        try:
            if not self.engine.execute(self, self.entry.get_text()):
                self.hide()
        except BadCommandException as e:
            dialog = gtk.MessageDialog(self, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, e.message)
            dialog.run()
            dialog.destroy()
            self.show_all()

    def entry_keypress(self, widget, event):
        if event.keyval == self.escape_key:
            self.seen_esc_press = True
        else:
            self.seen_esc_press = False

    def entry_keyrelease(self, widget, event):
        if event.keyval == self.escape_key and self.seen_esc_press:
            self.hide()
        self.seen_esc_press = False

