import gtk

import os

ICON_SEARCH_PATH = [
    os.path.join("/usr/share/pixmaps", "ginvoke.png"),
    os.path.join(
        os.path.dirname(__file__), '..', 'data', 'pixmaps', 'ginvoke.png')
]

ICON_PATH = None
ICON = None

def get_icon_path():
    global ICON_PATH
    if not ICON_PATH:
        for path in ICON_SEARCH_PATH:
            if os.path.exists(path):
                ICON_PATH = path
                break
    return ICON_PATH

def get_icon_pixbuf():
    global ICON
    if ICON is None:
        ICON = gtk.Image()
        ICON.set_from_file(get_icon_path())
    return ICON.get_pixbuf()

