#
# ginvoke: a programmable launcher for GTK+
# Copyright (C) 2011 Thomas Lee
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import gobject
import re

from .actions import wildcard

class Commands(gobject.GObject):
    def __init__(self):
        gobject.GObject.__init__(self)

        self._reset()

    def reset(self):
        self._reset()
        self.emit("reset-commands")

    def add(self, command, handler, *params):
        self.commands[command] = (handler, params)
        self.emit("add-command", command)

    def alias(self, command, alias):
        self.commands[alias] = self.commands[command]
        self.emit("add-command", alias)

    def setwildcard(self, handler, *params):
        self.wildcard = (handler, params)

    def __getitem__(self, command):
        try:
            return self.commands[command]
        except KeyError:
            return self.wildcard

    def __iter__(self):
        keys = self.commands.keys()
        keys.sort()
        return iter(keys)

    def _reset(self):
        self.commands = {}
        self.wildcard = (wildcard, tuple())

gobject.signal_new("add-command", Commands, gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [str])
gobject.signal_new("reset-commands", Commands, gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [])

