#
# ginvoke: a programmable launcher for GTK+
# Copyright (C) 2011 Thomas Lee
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os

import gobject

from .commands import Commands
import actions

class Settings(gobject.GObject):
    def __init__(self):
        gobject.GObject.__init__(self)

        self.run_at_login = False
        self.show_at_startup = True
        self.browser = "gnome-www-browser"
        self.host = "127.0.0.1"
        self.port = 19840
        self.commands = Commands()

    def load(self):
        files = (
            ("/etc/ginvoke/ginvoke.conf", False),
            (os.path.join(os.getenv("HOME"), ".ginvokerc"), True)
        )

        context = dict(actions.ALL)
        context["settings"] = self
        context["commands"] = self.commands

        for filename, mandatory in files:
            try:
                with open(filename, "r") as stream:
                    source = stream.read()
            except IOError as err:
                if mandatory:
                    raise
                else:
                    continue

            co = compile(source, filename, "exec")
            exec co in context

