import os
from ConfigParser import ConfigParser

default_config_path = '/usr/local/gitbucket/config'

class Config:

    def __init__(self, port, data_path):
        self.port = port
        self.data_path = data_path

def read_config(config_path=default_config_path):
    filename = os.path.join(config_path, 'gitbucket.cfg')

    parser = ConfigParser()
    parser.read(filename)

    port = parser.getint('gitbucket', 'port')
    data_path = parser.get('gitbucket', 'data_path')

    return Config(port, data_path)

def write_config(config, config_path=default_config_path):
    filename = os.path.join(config_path, 'gitbucket.cfg')

    parser = ConfigParser()
    parser.add_section('gitbucket')
    parser.set('gitbucket', 'port', config.port)
    parser.set('gitbucket', 'data_path', config.data_path)
    with open(filename, 'wb') as file:
        parser.write(file)
