from setuptools import setup
from setuptools.command.install_scripts import install_scripts
from subprocess import check_output

class PostInstall(install_scripts):
    def run(self):
        install_scripts.run(self)
        print "installing GitBucket"
        print check_output("install-gitbucket")

setup(
    name='gitbucket',
    version='2.6',
    scripts=['bin/install-gitbucket', 'bin/gitbucket'],
    description='GitBucket',
    packages=['gitbucket'],
    data_files=[
        ('gitbucket/config', ['config/gitbucket.cfg'])
    ],
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/gitbucket',
    cmdclass={"install_scripts": PostInstall}
)
