#!/usr/bin/env python
# coding: utf-8

import os, os.path, sys, re

class ObjId(object):

    def __init__(self, sha):
        self._sha = sha
        self._d, self._f = sha[0:2], sha[2:]
        self._sha_parts = None

    @property
    def d(self):
        return self._d
    @property
    def f(self):
        return self._f
    @property
    def sha(self):
        return self._sha

    @property
    def d_int(self):
        return int(self._d, 16)

    @property
    def sha_parts(self):
        if self._sha_parts is None:
            self._sha_parts = tuple([ int(self._sha[n*8:n*8+8], 16) for n in range(5) ])
        return self._sha_parts

    def __str__(self):
        return self._sha
