#!/usr/bin/env python
# encoding: utf-8
'''
bin.check_log -- shortdesc

bin.check_log is a description

It defines classes_and_methods

@author:     Shawn Crosby
            
@copyright:  2014 Salesforce.com. All rights reserved.
            
@license:    license

@contact:    scrosby@salesforce.com
@deffield    updated: 2014-07-16
'''

import sys
import os
import requests, datetime

from optparse import OptionParser

__all__ = []
__version__ = 0.1
__date__ = '2014-07-16'
__updated__ = '2014-07-16'

DEBUG = 0
TESTRUN = 0
PROFILE = 0

def main(argv=None):
    '''Command line options.'''
    
    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__
 
    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"
 
    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_option("-s", "--start", dest="start", action="store", help="Start date")
        parser.add_option("-e", "--end", dest="end", action="store", help="End Date")
        
        # set defaults
        today = datetime.date.today()
        tomorrow = today + datetime.timedelta(days=1)
        parser.set_defaults(start=today, end=tomorrow)
        
        # process options
        (opts, args) = parser.parse_args(argv)
        
        # MAIN BODY #
        r = requests.get('https://warm-ravine-1655.herokuapp.com/commits?start={}&end={}'.format(opts.start, opts.end), headers={'content-type':'application/json'})
        commits = r.json()
        
        print("|".rjust(126, '-'))
        print("{}{} {} {}".format("REPO".rjust(15), "COMMITTER".rjust(20), "BRANCH".rjust(20), "MESSAGE".rjust(50)))
        print("|".rjust(126, '-'))
        for commit in commits:
            if commit['gus_id'] is None and dont_filter(commit['message']):
                committer = bytes.decode(commit['committer'].encode('ascii','replace'))
                print("{}{} {} {}".format(commit['repo'].rjust(15)[:15], committer.rjust(20), commit['branch'].rjust(20)[:20], commit['message'].replace("\n","").rjust(50)[:50]))
    except Exception as e:
        raise e
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2
    
def dont_filter(string):
        prefix_filter = [
                         "Merge",
                         "Merged",
                         "New build number and link maps",
                         "Revert",
                         ]
        for prefix in prefix_filter:
            if string.startswith(prefix):
                return False
            
        return True

if __name__ == "__main__":
    if DEBUG:
        sys.argv.append("-h")
    if TESTRUN:
        import doctest
        doctest.testmod()
    if PROFILE:
        import cProfile
        import pstats
        profile_filename = 'bin.check_log_profile.txt'
        cProfile.run('main()', profile_filename)
        statsfile = open("profile_stats.txt", "wb")
        p = pstats.Stats(profile_filename, stream=statsfile)
        stats = p.strip_dirs().sort_stats('cumulative')
        stats.print_stats()
        statsfile.close()
        sys.exit(0)
    sys.exit(main())