'''
Created on Jul 23, 2014

@author: scrosby
'''
import requests, datetime

class Commits:
    def get_commits_for_date(self, start, end=None):
        if end is None:
            sdate = datetime.date.strpdate(start)
            end = sdate + datetime.datetimedelta(days=1)
        r = requests.get("https://warm-ravine-1655.herokuapp.com/commits?start={}&end={}".format(start, end))
        return self.filter_commits(r.json())
        
    def get_commits_with_gus_id(self, start, end=None):
        commits = self.get_commits_for_date(start, end)
        out = []
        for commit in commits:
            if commit['gus_id'] is not None:
                out.append(commit)
                
        return out
    
    def get_commits_without_gus_id(self, start, end=None):
        commits = self.get_commits_for_date(start, end)
        out = []
        for commit in commits:
            if commit['gus_id'] is None:
                out.append(commit)
                
        return out
    
    def get_unique_gus_ids(self, start, end=None):
        commits = self.get_commits_with_gus_id(start, end)
        out = []
        for commit in commits:
            if commit['gus_id'] not in out:
                out.append(commit['gus_id'])
                
        return out
    
    def get_commits_for_gus_id(self, gus_id):
        r = requests.get("https://warm-ravine-1655.herokuapp.com/commits?gus_id={}".format(gus_id))
        return self.filter_commits(r.json())
    
    def get_branches_for_gus_id(self, gus_id, versioned=True):
        commits = self.get_commits_for_gus_id(gus_id)
        out = []
        for commit in commits:
            branch = commit['branch']
            if branch not in out:
                if versioned == True:
                    if branch.endswith('release') or branch.endswith('maint') or branch == 'master':
                        out.append(branch)
                else:
                    out.append(branch)
        return out
    
    def get_unique_commit_ids_for_gus_id(self, gus_id):
        commits = self.get_commits_for_gus_id(gus_id)
        out = []
        for commit in commits:
            repo_id = "{}:{}".format(commit['repo'], commit['commit_id'])
            if repo_id not in out:
                out.append(repo_id)
                
        return out
    
    def get_commits_for_gus_id_on_branch(self, gus_id, branch):
        commits = self.get_commits_for_gus_id(gus_id)
        out = []
        for commit in commits:
            if commit['branch'] == branch:
                out.append(commit)
                
        return out
    
    def get_committers_for_gus_id(self, gus_id):
        commits = self.get_commits_for_gus_id(gus_id)
        out = []
        for commit in commits:
            committer = bytes.decode(commit['committer'].encode('ascii','replace'))
            if committer not in out:
                out.append(committer)
                
        return out
    
    def filter_commits(self, commits):
        out = []
        for commit in commits:
            branch = commit['branch']
            if branch == 'master' or branch.endswith('_release') or branch.endswith('_maint'):
                out.append(commit)
                
        return out
            