#!/usr/bin/env python
# -*- coding: utf-8 -*-
""" Setup file for github_events package """

from distutils.core import setup
import os


def is_package(path):
    return (
        os.path.isdir(path) and
        os.path.isfile(os.path.join(path, '__init__.py'))
    )


def find_packages(path, base=""):
    """ Find all packages in path """
    packages = {}
    for item in os.listdir(path):
        dir = os.path.join(path, item)
        if is_package(dir):
            if base:
                module_name = "%(base)s.%(item)s" % vars()
            else:
                module_name = item
            packages[module_name] = dir
            packages.update(find_packages(dir, module_name))
    return packages

setup(name='github_events',
      version='0.0.1',
      description='Shorthand way to get user github events',
      long_description=open("README.rst").read(),
      author='cancerhermit',
      author_email='cancerhermit@gmail.com',
      url='http://github.com/cancerhermit/PyGithubEvents/',
      packages = find_packages(".").keys(),
      install_requires=[
        "github"
      ],
      platforms =['All'],
      keywords="git github API events",
      classifiers=(
          'License :: OSI Approved :: GNU General Public License (GPL)',
          'Environment :: Console',

          'Natural Language :: English',

          'Programming Language :: Python',
          'Topic :: Software Development :: Libraries :: Python Modules',
          'Topic :: Utilities'
        ),
     license="GPL"
     )