class event:
    created_at = None
    type = None
    actor = None
    public = None
    payload = None
    repo = None

    def __init__(self,created_at=None,type=None,actor=None,public=None,payload=None,repo=None):
        self.created_at = created_at
        self.type = type
        self.actor = actor
        self.public = public
        self.repo = repo
        self.payload = payload

    @property
    def text(self):
        login=self.actor.login
        payload=self.payload
        if "action" in payload:
            action=payload["action"]
        else:
            action=None
        repo=self.repo
        if self.type=="CreateEvent":
            ref_type=payload['ref_type']
            name=repo.name.split("/")[-1]
            if ref_type=="repository":
                return "%s create repository %s" % (login,name)
            if ref_type=="branch":
                branch=payload['master_branch']
                return "%s create branch %s at repository %s" % (login,branch,name)
            raise TypeError("CreateEvent ref_type %s not implemeted yet" % ref_type)
        if self.type=="FollowEvent":
            if payload['target']['type']=="User":
                return "%s started following %s" % \
                (login,payload['target']['login'])
        if self.type=="ForkEvent":
            return "%s fork %s" % (login,repo.name)
        if self.type=="GistEvent":
            if action=="create":
                description=payload["gist"]["description"]
                url=payload['gist']['url']
                return "%s create gist:%s\n%s" % \
                (login,url.split("/")[-1],description)
            if action=="fork":
                description=payload["gist"]["description"]
                url=payload['gist']['url']
                return "%s fork gist:%s\n%s" % \
                (login,url.split("/")[-1],description)
            raise TypeError("GistEvent action %s not implemeted yet" % action)
        if self.type=="IssuesEvent":
            title=payload["issue"]["title"]
            url=payload["issue"]["url"]
            return "%s %s issue\n%s\n%s" % \
            (login,action,title,url)
        if self.type=="IssueCommentEvent":
            title=payload["issue"]["title"]
            url=payload["issue"]["url"]
            return "%s %s comment issue\n%s\n%s" % \
            (login,action,title,url)
        if self.type=="PullRequestEvent":
            return "%s opened pull request %s\n%s" % \
            (login,repo.name,payload['pull_request']['title'])
        if self.type=="PushEvent":
            branch=payload["ref"].split("/")[-1]
            messages=[]
            for commit in payload['commits']:
                messages.append(commit['message'])
            return "%s pushed to %s at %s\n%s" % \
            (login,branch,repo.name.split("/")[-1],"\n".join(messages)) 
        if self.type=="WatchEvent":
            return "%s watch %s" % (login,repo.name)
        raise TypeError("%s not implemeted yet" % self.type)


    def __str__(self):
        return self.text