# -*- coding: utf-8 -*-
from datetime import datetime
from time import mktime
import feedparser
from entry import entry
from thumbnail import thumbnail
from author import author


def url(user):
    return "https://github.com/%s.atom" % user


def struct2datetime(struct):
    return datetime.fromtimestamp(mktime(struct))


def entries(user):
    d = feedparser.parse(url(user))
    result = []
    for e in d.entries:
        i = entry(id=e.id,
                  updated=struct2datetime(e.updated_parsed),
                  published=struct2datetime(e.published_parsed),
                  link=e.link,
                  title=e.title,
                  author=author(
                  url=e.author_detail['href'],
                  name=e.author_detail['name']
                  ),
                  thumbnail=thumbnail(
                  url=e.media_thumbnail[0]['url'],
                  width=int(e.media_thumbnail[0]['width']),
                  height=int(e.media_thumbnail[0]['height'])
                  ),
                  html=e.summary
                  )
        result.append(i)
    return result