import unittest
from datetime import datetime
import githubatom


class Test(unittest.TestCase):
    def setUp(self):
        self.user = "cancerhermit"

    def url(self):
        return "https://github.com/%s.atom" % self.user

    def test_url(self):
        self.assertEqual(githubatom.url(self.user), self.url())

    def test_entries(self):
        for e in githubatom.entries(self.user):
            self.assertIsInstance(e.published, datetime)
            self.assertIsInstance(e.updated, datetime)
            self.assertIsInstance(e.updated, datetime)
            self.assertIsNotNone(e.link)
            self.assertIsNotNone(e.title)
            self.assertIsNotNone(e.author)
            self.assertIsNotNone(e.author.name)
            self.assertIsNotNone(e.author.url)
            self.assertIsNotNone(e.thumbnail)
            self.assertIsNotNone(e.thumbnail.url)
            self.assertIsNotNone(e.thumbnail.width)
            self.assertIsNotNone(e.thumbnail.height)
            self.assertIsInstance(e.thumbnail.width, int)
            self.assertIsInstance(e.thumbnail.height, int)
            self.assertIsNotNone(e.html)


if __name__ == "__main__":
    unittest.main()