__author__ = 'ardevelop'

import json
import datetime
import subprocess

import yaml
import tornado.web
import tornado.ioloop


class Processor(object):
    def __init__(self, application, request):
        self.application = application
        self.request = request

        try:
            self.event = request["headers"]["X-GitHub-Event"]
            self.branch = request["payload"]["ref"].split("/")[-1]
        except Exception, ex:
            print "ERROR:", "processor constructor", ex
            self.application.ioloop.add_timeout(self.application.interval, self.application.next)
        else:
            self.tasks = ["git checkout %s" % self.branch, "git pull origin %s" % self.branch, self.read_config]
            self.process = None
            self.application.ioloop.add_timeout(self.application.interval, self.next)

    def read_config(self):
        with open(self.application.config_filename) as config_file:
            config = yaml.safe_load(config_file)

        try:
            tasks = config[self.branch][self.event]
            assert isinstance(tasks, list)
        except (KeyError, AssertionError), ex:
            print "ERROR:", "read_config", ex
        else:
            self.tasks.extend(tasks)

    def next(self):
        try:
            task = self.tasks.pop(0)
        except IndexError:
            self.application.ioloop.add_timeout(self.application.interval, self.application.next)
        else:
            print "new_task", task

            if hasattr(task, "__call__"):
                task()
                self.application.ioloop.add_timeout(self.application.interval, self.next)
            else:
                try:
                    self.process = subprocess.Popen(task, shell=True)
                except OSError, ex:
                    self.error(ex)
                else:
                    self.application.ioloop.add_timeout(self.application.interval, self.wait)

    def error(self, ex):
        self.application.ioloop.add_timeout(self.application.interval, self.application.next)

    def wait(self):
        return_code = self.process.returncode
        print "wait", return_code
        if return_code is None:
            self.application.ioloop.add_timeout(self.application.interval, self.wait)
        elif return_code == 0:
            self.application.ioloop.add_timeout(self.application.interval, self.next)
        else:
            self.error(return_code)


class Application(tornado.web.Application):
    def __init__(self, config_filename="ci.yml", interval=1):
        super(Application, self).__init__([(".*", Handler)])
        self.queue = []
        self.current = None

        self.ioloop = tornado.ioloop.IOLoop.instance()

        self.config_filename = config_filename
        self.interval = datetime.timedelta(seconds=interval)

        self.ioloop.add_timeout(self.interval, self.next)

    def next(self):
        try:
            request = self.queue.pop(0)
        except IndexError:
            print "No work"
            self.current = None
            self.ioloop.add_timeout(self.interval, self.next)
        else:
            print "New task"
            self.current = Processor(self, request)


class Handler(tornado.web.RequestHandler):
    def get(self):
        self.finish(json.dumps({
            "queue": self.application.queue
        }))

    def post(self):
        try:
            request = {
                "headers": self.request.headers,
                "payload": json.loads(self.request.body)
            }
        except ValueError, ex:
            print "ERROR:", ex
            raise tornado.web.HTTPError(400)
        else:
            self.application.queue.append(request)