import os
import githubci

__author__ = 'ardevelop'


if "__main__" == __name__:
    import argparse

    parser = argparse.ArgumentParser(prog="githubci",
                                     description="A simple realization of Continuous Integration for GitHub")
    parser.add_argument("repository", type=str, help="path to repository")
    parser.add_argument("-i", "--interface", type=str, help="listen interface", default="127.0.0.1")
    parser.add_argument("-p", "--port", type=int, help="listen port", default=9092)
    parser.add_argument("-c", "--config", type=str, help="configuration filename", default="ci.yml")

    args = parser.parse_args()

    os.chdir(args.repository)

    app = githubci.Application(config_filename=args.config)
    app.listen(args.port, args.interface)
    app.ioloop.start()