from os import getcwd
from os.path import basename, splitext
from git import Repo
from github import Github
from github.GithubException import GithubException
from github.GithubObject import NotSet

from shell import shell

def user():
    """return git config user.name"""
    try:
        return shell("git config user.name")
    except:
        raise Exception("git config user.name undefined") 

def password():
    """return git config github.password"""
    try:
        return shell("git config github.password")
    except:
        raise Exception("git config user.name undefined") 

def get_user():
    """return Github().get_user()"""
    return Github(user(),password()).get_user()

def create(name=basename(getcwd()),description=NotSet, homepage=NotSet, private=NotSet, has_issues=NotSet):
    """create remote add github if not exists and create remote repository"""
    try:
        repo=Repo(getcwd())
    except Exception:
        raise IOError("%s not git repository" % getcwd())
    if repo:
        exists=False
        for r in repo.remotes:
            if r.url.find("gist.github.com")>=0:
                return # makes nothing with gists
            if r.url.find("github.com")>=0:
                exists=True
        if not exists:
            url = 'git@github.com:%s/%s.git' % (user(),name)
            repo.create_remote('github', url)
        # try create repository every time
        u=get_user()
        try:
            u.get_repo(name)
        except GithubException: # repo not exists
            u.create_repo(name, 
                description=description, 
                homepage=homepage, 
                private=private, 
                has_issues=has_issues)

def edit(description=NotSet, homepage=NotSet, public=NotSet):
    """edit github repository description/homepage/etc"""
    for r in Repo(getcwd()).remotes:
        if r.url.find("gist.github.com")>=0:
            return # makes nothing with gists
        if r.url.find("github.com")>=0:
            # github repository
            name=splitext(basename(r.url))[0]
            repo=get_user().get_repo(name)
            if not description:
                description=repo.description
            if not homepage:
                homepage=repo.homepage
            if not public:
                public=repo.public
            if repo.description!=description or \
            repo.homepage!=description or\
            repo.public!=public:
                # change repository settings
                repo.edit(
                    repo.name,
                    description=description,
                    homepage=homepage,
                    public=public
                )