#!/usr/bin/python
#coding:utf-8

from commands import getoutput
from sys import argv, exit
import os

__author__ = "Alice"
__version__ = "1.5.0"
__copyright__ = "Copyright Alice All Rights Reserved."

class GitStatus:
	def __init__(self):
		self.logbody = getoutput("git log").split("\n")
		self.lastcommit = self.logbody[0].split(" ")[1]
		self.status = getoutput("git cat-file commit %s" % self.lastcommit).split("\n")
		self.tree = sorted(getoutput("git ls-tree %s" % self.lastcommit).split("\n"))
	
	def getattr(self,attr_name):
		self.line = [i for i in self.tree if attr_name in i]
		self.item = {}
		
		for i in self.line:
			__line = i.split(" ")
			__name = __line[-1].split("\t")
			self.item[__name[1]] = {"hash": __name[0],
							"type": __line[1],
							"code": __line[0]}
							
	def help(self):
		print "Usage: $ gitstatus <cmd> <arguments>"
		print "cmd:"
		print "  1, nomal -- show status."
		print "  2, tree <*type> -- show tree of repogitry."
		print "  3, attr <file>  -- show attribute of file."
		print "  4, hash <file>  -- show hash of file."
		print "  5, cat  <file>  -- show contents of file."
		print "  6, log          -- export log file."
		exit(1)
		

git = GitStatus()

try: cmd=argv[1]
except: cmd="nomal"

if cmd=="nomal":
	print "Last Commited Object: %s" % git.lastcommit
	print "Print STATUS:"
	print "----------------"
	for i in git.status: print i

elif cmd=="tree":
	try: mode=argv[2]
	except: mode="nomal"
	
	files = os.listdir("./")
	
	if mode=="nomal":	
		print "Print TREE:"
		print "----------------"
		for i in git.tree: print i
		
	else:
		print "Print %s OF TREE" % mode
		print "----------------"
		for i in git.tree:
			if mode in i:
				print i
			
elif cmd=="attr":
	try: file=argv[2]
	except: print git.help()
	
	for i in git.tree:
		if file in i: print i

elif cmd=="hash":
	try: file=argv[2]
	except: print git.help()
	
	git.getattr(file)
	print git.item[file]["hash"]
	
elif cmd=="cat":
	try: file=argv[2]
	except: print git.help()
	
	if file == "log":
		os.system("git log");exit(1)
	
	git.getattr(file)
	hash = git.item[file]["hash"]
	type = git.item[file]["type"]
	body = getoutput("git cat-file %s %s" % (type,hash) ).split("\n")
	for i in body: print i

elif cmd=="log":
	dir = os.getcwd()
	file = dir+"/git_log"
	os.system("git log > %s" % file)
	print "Exported Log."

elif cmd=="help":
	print git.help()

elif cmd=="version" or cmd=="-v":
	print "Version : ",__version__
	
	
else:
	print "I don't know your command."
	print git.help()
