import re
import os
from datetime import datetime
from subprocess import check_output

from gitwrapper import helper


__version__ = '0.1.0a1.dev1'
__license__ = 'MIT'
__copyright__ = '(c) 2014 Stefan Tatschner <stefan@sevenbyte.org>'


class Repo:

    def __init__(self, path):
        self.path = path
        os.chdir(path)

    def init(self):
        return helper._run_git('init')

    def status(self):
        args = ['-s']
        raw = helper._run_git('status', args)
        return helper._parse_status(raw.decode())

    def add(self):
        args = ['.', '--all']
        return helper._run_git('add', args)

    def commit(self, message):
        args = ['-m', message]
        return helper._run_git('commit', args)

    def log(self, between=None):
        args = ['--date=iso']
        if between:
            args.append(between)
        raw = helper._run_git('log', args)
        return helper._parse_log(raw.decode())

    def diff(self):
        return helper._run_git('diff')

    def is_repo(self):
        # TODO: Support bare repos
        if os.path.exists('.git'):
            return True
        else:
            return False
