# -*- coding: utf-8 -*-

import kola.callbacks_mixin
from gevent.server import StreamServer
from .connection import Connection
from .stream import GStream


class GKola(kola.callbacks_mixin.AppCallBacksMixin):
    debug = False
    conn_class = None
    blueprints = None
    got_first_request = False

    def __init__(self, conn_class=None, **kwargs):
        super(GKola, self).__init__()

        self.conn_class = conn_class or Connection

        self.blueprints = dict()

    def handle_stream(self, sock, address):
        self.conn_class(self, GStream(sock), address)

    def run(self, host, port):
        server = StreamServer((host, port), self.handle_stream)
        server.serve_forever()

    def register_blueprint(self, blueprint):
        blueprint.register2app(self)
