# -*- coding: utf-8 -*-

import time
import gevent
from kola.utils import safe_call


class TimeoutMgr(object):

    timeout = None
    deadline = None

    def set(self, interval, callback, repeat=False, force=True):
        """
        添加timeout
        """
        if self.timeout:
            if force:
                # 如果已经存在，那么先要把现在的清空
                self.clear()
            else:
                # 已经存在的话，就返回了
                return

        deadline = time.time() + interval

        def callback_wrapper():
            # 这样可以让timeout及时变成None
            if self.timeout and deadline == self.deadline:
                # 必须要确定，这次调用就是这个timeout引起的
                self.timeout = None
                result = safe_call(callback)
                if repeat:
                    # 重复的调用
                    self.set(interval, callback, repeat=repeat)
                return result

        self.deadline = deadline
        self.timeout = gevent.spawn_later(interval, callback_wrapper)

    def clear(self):
        """
        直接把现在的清空
        """
        if not self.timeout:
            return

        # 不阻塞
        self.timeout.kill(block=False)
        self.timeout = None
        self.deadline = None
