# -*- coding: utf-8 -*-

import gevent
import kola.connection
from kola.utils import safe_call

from kola.vals import logger


class Connection(kola.connection.Connection):

    def process(self):
        while not self.stream.closed():
            self._read_message()

    def _read_message(self):
        # 按照官方文档，greenlet在存活的时候，是不参与内存回收的
        # 只有greenlet在释放的时候，所有引用才会释放

        job = gevent.spawn(self.stream.readline, self._on_read_complete)
        job.join()

    def _on_read_complete(self, raw_data):
        """
        数据获取结束，修改为不要循环获取数据，解决内存泄漏
        """
        logger.debug('raw_data: %s', raw_data)
        request = self.request_class(self, raw_data)
        self._handle_request(request)
