# -*- coding: utf-8 -*-

import gevent
import kola.connection
from kola.utils import safe_call


class Connection(kola.connection.Connection):

    def process(self):
        while not self.stream.closed():
            self._read_message()

    def _read_message(self):
        # 按照官方文档，greenlet在存活的时候，是不参与内存回收的
        # 只有greenlet在释放的时候，所有引用才会释放

        job = gevent.spawn(self.stream.read_until, self.terminator, self._on_read_complete)
        job.join()
