# -*- coding: utf-8 -*-

import functools
import gevent
import kola
from kola.utils import safe_call


class Blueprint(kola.Blueprint):
    """
    主要改掉
    """

    def __init__(self, name):
        super(Blueprint, self).__init__(name)
        self.repeat_app_timer_func_list = []

    def repeat_app_timer(self, interval):
        """
        每隔一段时间执行(秒)
        """
        def inner_repeat_timer(func):
            @functools.wraps(func)
            def func_wrapper(*args, **kwargs):
                # 每次也要再加入

                result = safe_call(func, *args, **kwargs)
                gevent.spawn_later(interval, func_wrapper)

                return result

            self.repeat_app_timer_func_list.append(func_wrapper)
            return func_wrapper
        return inner_repeat_timer
