# -*- coding: utf-8 -*-

import functools
import gevent
from gevent.server import StreamServer
import kola
from kola import safe_call
from .connection import Connection
from .stream import GStream


class Kola(kola.Kola):

    server = None

    def __init__(self, server_class=None, conn_class=None):
        super(Kola, self).__init__()
        self.repeat_timer_func_list = []
        self.server_class = server_class or StreamServer
        self.conn_class = conn_class or Connection

    def handle_stream(self, sock, address):
        self.conn_class(self, GStream(sock), address).process()

    def run(self, host, port, patch_all=True):
        if patch_all:
            from gevent import monkey
            monkey.patch_all()

        self._start_repeat_timers()
        self.server = self.server_class((host, port), self.handle_stream)
        self.server.serve_forever()

    def register_blueprint(self, blueprint):
        blueprint.register2app(self)

    def repeat_timer(self, interval):
        """
        每隔一段时间执行(秒)
        """
        def inner_repeat_timer(func):
            @functools.wraps(func)
            def func_wrapper(*args, **kwargs):
                # 每次也要再加入

                result = safe_call(func, *args, **kwargs)
                gevent.spawn_later(interval, func_wrapper)

                return result

            self.repeat_timer_func_list.append(func_wrapper)
            return func_wrapper
        return inner_repeat_timer

    def _start_repeat_timers(self):
        """
        把那些repeat timers启动
        """
        for func in self.repeat_timer_func_list:
            safe_call(func)
        # 执行blueprints
        for name, bp in self.blueprints.items():
            for func in bp.repeat_app_timer_func_list:
                safe_call(func)
