# -*- coding: utf-8 -*-

import kola.callbacks_mixin
from gevent.server import StreamServer
from .connection import Connection
from .stream import GStream
from .callbacks_mixin import PathedCallBacksMixin


class Kola(kola.callbacks_mixin.AppCallBacksMixin, PathedCallBacksMixin):
    debug = False
    conn_class = None
    blueprints = None
    got_first_request = False

    def __init__(self, conn_class=None, **kwargs):
        super(Kola, self).__init__()

        self.conn_class = conn_class or Connection

        self.blueprints = dict()

        self.repeat_timer = self._patched_repeat_timer

    def handle_stream(self, sock, address):
        self.conn_class(self, GStream(sock), address)

    def run(self, host, port, patch_all=True):
        if patch_all:
            from gevent import monkey
            monkey.patch_all()

        server = StreamServer((host, port), self.handle_stream)
        server.serve_forever()

    def register_blueprint(self, blueprint):
        blueprint.register2app(self)
