# -*- coding: utf-8 -*-

import gevent
import functools
from kola.utils import safe_call


class PathedCallBacksMixin(object):
    def _patched_repeat_timer(self, interval):
        """
        每隔一段时间执行(秒)
        """
        def inner_repeat_timer(func):
            @functools.wraps(func)
            def func_wrapper(*args, **kwargs):
                # 每次也要再加入

                result = safe_call(func, *args, **kwargs)
                gevent.spawn_later(interval, func_wrapper)

                return result

            gevent.spawn_later(interval, func_wrapper)
            return func_wrapper
        return inner_repeat_timer
