# -*- coding: utf-8 -*-

import re
import gkola

from .stream import Stream


class Kola(gkola.Kola):

    re_path = None

    def __init__(self, re_path, conn_class=None):
        super(Kola, self).__init__(conn_class=conn_class)

        self.re_path = re_path

    def handle_stream(self, ws, address):
        self.conn_class(self, Stream(ws), address).process()

    def prepare(self):
        """
        准备工作，比如启动repeat_timers
        """
        self._start_repeat_timers()

    def wsgi(self, org_app):
        """
        将原始的app，包装为包括websocket的app
        """

        def new_wsgi(environ, start_response):

            path = environ['PATH_INFO']

            if re.match(self.re_path, path):
                # 说明是websocket
                ws = environ['wsgi.websocket']
                address = environ.get('REMOTE_ADDR')
                self.handle_stream(ws, address)
            else:
                return org_app(environ, start_response)

        return new_wsgi
