# -*- coding: utf-8 -*-

import pickle
import msgpack

from gmemcache.serializer import MsgpackSerializer, PickleSerializer

from nose.tools import *


def test_msgpack_serializer():
    ins = MsgpackSerializer()
    serialized = ins.serialize('test_string')
    eq_('test_string', msgpack.unpackb(serialized))
    eq_('test_string', ins.deserialize(serialized))


def test_pickle_serializer():
    ins = PickleSerializer()
    serialized = ins.serialize('test_string')
    eq_('test_string', pickle.loads(serialized))
    eq_('test_string', ins.deserialize(serialized))
