# -*- coding: utf-8 -*-

import msgpack
import cPickle


class BaseSerializer(object):
    def serialize(self, value):
        """Serializes the value.

        :param object value: Value to be serialized.
        """
        raise NotImplementedError()

    def deserialize(self, value):
        """Deserializes the value.

        :param object value: Value to be deserialized.
        """

        raise NotImplementedError()


class MsgpackSerializer(BaseSerializer):
    """Serializer based on MessagePack."""

    def serialize(self, value):
        return msgpack.packb(value, encoding='utf-8')

    def deserialize(self, value):
        return msgpack.unpackb(value, encoding='utf-8', use_list=False)


class PickleSerializer(BaseSerializer):
    """Serializer based on cPickle."""

    def serialize(self, value):
        return cPickle.dumps(value, protocol=-1)

    def deserialize(self, value):
        return cPickle.loads(value)
