# Copyright (C) 2014 Daniel Lintott.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
import os.path


def fix_path(path):
    """
    Fix windows path's. Linux path's will remain unaltered

    :param str path: The path to be fixed
    :return: The fixed path
    :rtype: str
    """
    if '\\' in path:
        path = path.replace('\\', '/')

    path = os.path.normpath(path)

    return path

