# Copyright (C) Oracle Corporation
#
# This file is part of VirtualBox Open Source Edition (OSE), as
# available from http://www.virtualbox.org. This file is free software;
# you can redistribute it and/or modify it under the terms of the GNU
# General Public License (GPL) as published by the Free Software
# Foundation, in version 2 as it comes in the "COPYING" file of the
# VirtualBox OSE distribution. VirtualBox OSE is distributed in the
# hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
#
# This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
#

class VirtualBoxReflectionInfo:
   def __init__(self, isSym):
      self.isSym = isSym

   _Values = {
                'SettingsVersion':{
                  'Null':0,'v1_0':1,'v1_1':2,'v1_2':3,'v1_3pre':4,'v1_3':5,'v1_4':6,'v1_5':7,'v1_6':8,'v1_7':9,'v1_8':10,'v1_9':11,'v1_10':12,'v1_11':13,'v1_12':14,'v1_13':15,'Future':99999},
                'AccessMode':{
                  'ReadOnly':1,'ReadWrite':2},
                'MachineState':{
                  'Null':0,'PoweredOff':1,'Saved':2,'Teleported':3,'Aborted':4,'Running':5,'Paused':6,'Stuck':7,'Teleporting':8,'LiveSnapshotting':9,'Starting':10,'Stopping':11,'Saving':12,'Restoring':13,'TeleportingPausedVM':14,'TeleportingIn':15,'FaultTolerantSyncing':16,'DeletingSnapshotOnline':17,'DeletingSnapshotPaused':18,'RestoringSnapshot':19,'DeletingSnapshot':20,'SettingUp':21,'FirstOnline':5,'LastOnline':18,'FirstTransient':8,'LastTransient':21},
                'SessionState':{
                  'Null':0,'Unlocked':1,'Locked':2,'Spawning':3,'Unlocking':4},
                'CPUPropertyType':{
                  'Null':0,'PAE':1,'Synthetic':2},
                'HWVirtExPropertyType':{
                  'Null':0,'Enabled':1,'Exclusive':2,'VPID':3,'NestedPaging':4,'LargePages':5,'Force':6},
                'FaultToleranceState':{
                  'Inactive':1,'Master':2,'Standby':3},
                'LockType':{
                  'Write':2,'Shared':1,'VM':3},
                'SessionType':{
                  'Null':0,'WriteLock':1,'Remote':2,'Shared':3},
                'DeviceType':{
                  'Null':0,'Floppy':1,'DVD':2,'HardDisk':3,'Network':4,'USB':5,'SharedFolder':6},
                'DeviceActivity':{
                  'Null':0,'Idle':1,'Reading':2,'Writing':3},
                'ClipboardMode':{
                  'Disabled':0,'HostToGuest':1,'GuestToHost':2,'Bidirectional':3},
                'DragAndDropMode':{
                  'Disabled':0,'HostToGuest':1,'GuestToHost':2,'Bidirectional':3},
                'Scope':{
                  'Global':0,'Machine':1,'Session':2},
                'BIOSBootMenuMode':{
                  'Disabled':0,'MenuOnly':1,'MessageAndMenu':2},
                'ProcessorFeature':{
                  'HWVirtEx':0,'PAE':1,'LongMode':2,'NestedPaging':3},
                'FirmwareType':{
                  'BIOS':1,'EFI':2,'EFI32':3,'EFI64':4,'EFIDUAL':5},
                'PointingHIDType':{
                  'None':1,'PS2Mouse':2,'USBMouse':3,'USBTablet':4,'ComboMouse':5},
                'KeyboardHIDType':{
                  'None':1,'PS2Keyboard':2,'USBKeyboard':3,'ComboKeyboard':4},
                'VFSType':{
                  'File':1,'Cloud':2,'S3':3,'WebDav':4},
                'VFSFileType':{
                  'Unknown':1,'Fifo':2,'DevChar':3,'Directory':4,'DevBlock':5,'File':6,'SymLink':7,'Socket':8,'WhiteOut':9},
                'ImportOptions':{
                  'KeepAllMACs':1,'KeepNATMACs':2},
                'VirtualSystemDescriptionType':{
                  'Ignore':1,'OS':2,'Name':3,'Product':4,'Vendor':5,'Version':6,'ProductUrl':7,'VendorUrl':8,'Description':9,'License':10,'Miscellaneous':11,'CPU':12,'Memory':13,'HardDiskControllerIDE':14,'HardDiskControllerSATA':15,'HardDiskControllerSCSI':16,'HardDiskControllerSAS':17,'HardDiskImage':18,'Floppy':19,'CDROM':20,'NetworkAdapter':21,'USBController':22,'SoundCard':23,'SettingsFile':24},
                'VirtualSystemDescriptionValueType':{
                  'Reference':1,'Original':2,'Auto':3,'ExtraConfig':4},
                'CleanupMode':{
                  'UnregisterOnly':1,'DetachAllReturnNone':2,'DetachAllReturnHardDisksOnly':3,'Full':4},
                'CloneMode':{
                  'MachineState':1,'MachineAndChildStates':2,'AllStates':3},
                'CloneOptions':{
                  'Link':1,'KeepAllMACs':2,'KeepNATMACs':3,'KeepDiskNames':4},
                'AutostopType':{
                  'Disabled':1,'SaveState':2,'PowerOff':3,'AcpiShutdown':4},
                'HostNetworkInterfaceMediumType':{
                  'Unknown':0,'Ethernet':1,'PPP':2,'SLIP':3},
                'HostNetworkInterfaceStatus':{
                  'Unknown':0,'Up':1,'Down':2},
                'HostNetworkInterfaceType':{
                  'Bridged':1,'HostOnly':2},
                'AdditionsFacilityType':{
                  'None':0,'VBoxGuestDriver':20,'AutoLogon':90,'VBoxService':100,'VBoxTrayClient':101,'Seamless':1000,'Graphics':1100,'All':2147483646},
                'AdditionsFacilityClass':{
                  'None':0,'Driver':10,'Service':30,'Program':50,'Feature':100,'ThirdParty':999,'All':2147483646},
                'AdditionsFacilityStatus':{
                  'Inactive':0,'Paused':1,'PreInit':20,'Init':30,'Active':50,'Terminating':100,'Terminated':101,'Failed':800,'Unknown':999},
                'AdditionsRunLevelType':{
                  'None':0,'System':1,'Userland':2,'Desktop':3},
                'AdditionsUpdateFlag':{
                  'None':0,'WaitForUpdateStartOnly':1},
                'FileSeekType':{
                  'Set':0,'Current':1},
                'ProcessInputFlag':{
                  'None':0,'EndOfFile':1},
                'ProcessOutputFlag':{
                  'None':0,'StdErr':1},
                'ProcessWaitForFlag':{
                  'None':0,'Start':1,'Terminate':2,'StdIn':4,'StdOut':8,'StdErr':16},
                'ProcessWaitResult':{
                  'None':0,'Start':1,'Terminate':2,'Status':3,'Error':4,'Timeout':5,'StdIn':6,'StdOut':7,'StdErr':8,'WaitFlagNotSupported':9},
                'CopyFileFlag':{
                  'None':0,'Recursive':1,'Update':2,'FollowLinks':4},
                'DirectoryCreateFlag':{
                  'None':0,'Parents':1},
                'DirectoryRemoveRecFlag':{
                  'None':0,'ContentAndDir':1,'ContentOnly':2},
                'PathRenameFlag':{
                  'None':0,'NoReplace':1,'Replace':2,'NoSymlinks':4},
                'ProcessCreateFlag':{
                  'None':0,'WaitForProcessStartOnly':1,'IgnoreOrphanedProcesses':2,'Hidden':4,'NoProfile':8,'WaitForStdOut':16,'WaitForStdErr':32,'ExpandArguments':64},
                'ProcessPriority':{
                  'Invalid':0,'Default':1},
                'SymlinkType':{
                  'Unknown':0,'Directory':1,'File':2},
                'SymlinkReadFlag':{
                  'None':0,'NoSymlinks':1},
                'ProcessStatus':{
                  'Undefined':0,'Starting':10,'Started':100,'Paused':110,'Terminating':480,'TerminatedNormally':500,'TerminatedSignal':510,'TerminatedAbnormally':511,'TimedOutKilled':512,'TimedOutAbnormally':513,'Down':600,'Error':800},
                'FsObjType':{
                  'Undefined':0,'FIFO':1,'DevChar':10,'DevBlock':11,'Directory':50,'File':80,'Symlink':100,'Socket':200,'Whiteout':400},
                'DragAndDropAction':{
                  'Ignore':0,'Copy':1,'Move':2,'Link':3},
                'DirectoryOpenFlag':{
                  'None':0,'NoSymlinks':1},
                'MediumState':{
                  'NotCreated':0,'Created':1,'LockedRead':2,'LockedWrite':3,'Inaccessible':4,'Creating':5,'Deleting':6},
                'MediumType':{
                  'Normal':0,'Immutable':1,'Writethrough':2,'Shareable':3,'Readonly':4,'MultiAttach':5},
                'MediumVariant':{
                  'Standard':0,'VmdkSplit2G':0x01,'VmdkRawDisk':0x02,'VmdkStreamOptimized':0x04,'VmdkESX':0x08,'Fixed':0x10000,'Diff':0x20000,'NoCreateDir':0x40000000},
                'DataType':{
                  'Int32':0,'Int8':1,'String':2},
                'DataFlags':{
                  'None':0x00,'Mandatory':0x01,'Expert':0x02,'Array':0x04,'FlagMask':0x07},
                'MediumFormatCapabilities':{
                  'Uuid':0x01,'CreateFixed':0x02,'CreateDynamic':0x04,'CreateSplit2G':0x08,'Differencing':0x10,'Asynchronous':0x20,'File':0x40,'Properties':0x80,'TcpNetworking':0x100,'VFS':0x200,'CapabilityMask':0x3FF},
                'MouseButtonState':{
                  'LeftButton':0x01,'RightButton':0x02,'MiddleButton':0x04,'WheelUp':0x08,'WheelDown':0x10,'XButton1':0x20,'XButton2':0x40,'MouseStateMask':0x7F},
                'FramebufferPixelFormat':{
                  'Opaque':0,'FOURCC_RGB':0x32424752},
                'NetworkAttachmentType':{
                  'Null':0,'NAT':1,'Bridged':2,'Internal':3,'HostOnly':4,'Generic':5},
                'NetworkAdapterType':{
                  'Null':0,'Am79C970A':1,'Am79C973':2,'I82540EM':3,'I82543GC':4,'I82545EM':5,'Virtio':6},
                'NetworkAdapterPromiscModePolicy':{
                  'Deny':1,'AllowNetwork':2,'AllowAll':3},
                'PortMode':{
                  'Disconnected':0,'HostPipe':1,'HostDevice':2,'RawFile':3},
                'USBDeviceState':{
                  'NotSupported':0,'Unavailable':1,'Busy':2,'Available':3,'Held':4,'Captured':5},
                'USBDeviceFilterAction':{
                  'Null':0,'Ignore':1,'Hold':2},
                'AudioDriverType':{
                  'Null':0,'WinMM':1,'OSS':2,'ALSA':3,'DirectSound':4,'CoreAudio':5,'MMPM':6,'Pulse':7,'SolAudio':8},
                'AudioControllerType':{
                  'AC97':0,'SB16':1,'HDA':2},
                'AuthType':{
                  'Null':0,'External':1,'Guest':2},
                'StorageBus':{
                  'Null':0,'IDE':1,'SATA':2,'SCSI':3,'Floppy':4,'SAS':5},
                'StorageControllerType':{
                  'Null':0,'LsiLogic':1,'BusLogic':2,'IntelAhci':3,'PIIX3':4,'PIIX4':5,'ICH6':6,'I82078':7,'LsiLogicSas':8},
                'ChipsetType':{
                  'Null':0,'PIIX3':1,'ICH9':2},
                'NATAliasMode':{
                  'AliasLog':0x1,'AliasProxyOnly':0x02,'AliasUseSamePorts':0x04},
                'NATProtocol':{
                  'UDP':0,'TCP':1},
                'BandwidthGroupType':{
                  'Null':0,'Disk':1,'Network':2},
                'VBoxEventType':{
                  'Invalid':0,'Any':1,'Vetoable':2,'MachineEvent':3,'SnapshotEvent':4,'InputEvent':5,'LastWildcard':31,'OnMachineStateChanged':32,'OnMachineDataChanged':33,'OnExtraDataChanged':34,'OnExtraDataCanChange':35,'OnMediumRegistered':36,'OnMachineRegistered':37,'OnSessionStateChanged':38,'OnSnapshotTaken':39,'OnSnapshotDeleted':40,'OnSnapshotChanged':41,'OnGuestPropertyChanged':42,'OnMousePointerShapeChanged':43,'OnMouseCapabilityChanged':44,'OnKeyboardLedsChanged':45,'OnStateChanged':46,'OnAdditionsStateChanged':47,'OnNetworkAdapterChanged':48,'OnSerialPortChanged':49,'OnParallelPortChanged':50,'OnStorageControllerChanged':51,'OnMediumChanged':52,'OnVRDEServerChanged':53,'OnUSBControllerChanged':54,'OnUSBDeviceStateChanged':55,'OnSharedFolderChanged':56,'OnRuntimeError':57,'OnCanShowWindow':58,'OnShowWindow':59,'OnCPUChanged':60,'OnVRDEServerInfoChanged':61,'OnEventSourceChanged':62,'OnCPUExecutionCapChanged':63,'OnGuestKeyboard':64,'OnGuestMouse':65,'OnNATRedirect':66,'OnHostPCIDevicePlug':67,'OnVBoxSVCAvailabilityChanged':68,'OnBandwidthGroupChanged':69,'OnGuestMonitorChanged':70,'OnStorageDeviceChanged':71,'OnClipboardModeChanged':72,'OnDragAndDropModeChanged':73,'Last':74},
                'GuestMonitorChangedEventType':{
                  'Enabled':0,'Disabled':1,'NewOrigin':2}}

   _ValuesSym = {
                'SettingsVersion':{
                  'Null': 'Null','v1_0': 'v1_0','v1_1': 'v1_1','v1_2': 'v1_2','v1_3pre': 'v1_3pre','v1_3': 'v1_3','v1_4': 'v1_4','v1_5': 'v1_5','v1_6': 'v1_6','v1_7': 'v1_7','v1_8': 'v1_8','v1_9': 'v1_9','v1_10': 'v1_10','v1_11': 'v1_11','v1_12': 'v1_12','v1_13': 'v1_13','Future': 'Future'},
                'AccessMode':{
                  'ReadOnly': 'ReadOnly','ReadWrite': 'ReadWrite'},
                'MachineState':{
                  'Null': 'Null','PoweredOff': 'PoweredOff','Saved': 'Saved','Teleported': 'Teleported','Aborted': 'Aborted','Running': 'Running','Paused': 'Paused','Stuck': 'Stuck','Teleporting': 'Teleporting','LiveSnapshotting': 'LiveSnapshotting','Starting': 'Starting','Stopping': 'Stopping','Saving': 'Saving','Restoring': 'Restoring','TeleportingPausedVM': 'TeleportingPausedVM','TeleportingIn': 'TeleportingIn','FaultTolerantSyncing': 'FaultTolerantSyncing','DeletingSnapshotOnline': 'DeletingSnapshotOnline','DeletingSnapshotPaused': 'DeletingSnapshotPaused','RestoringSnapshot': 'RestoringSnapshot','DeletingSnapshot': 'DeletingSnapshot','SettingUp': 'SettingUp','FirstOnline': 'FirstOnline','LastOnline': 'LastOnline','FirstTransient': 'FirstTransient','LastTransient': 'LastTransient'},
                'SessionState':{
                  'Null': 'Null','Unlocked': 'Unlocked','Locked': 'Locked','Spawning': 'Spawning','Unlocking': 'Unlocking'},
                'CPUPropertyType':{
                  'Null': 'Null','PAE': 'PAE','Synthetic': 'Synthetic'},
                'HWVirtExPropertyType':{
                  'Null': 'Null','Enabled': 'Enabled','Exclusive': 'Exclusive','VPID': 'VPID','NestedPaging': 'NestedPaging','LargePages': 'LargePages','Force': 'Force'},
                'FaultToleranceState':{
                  'Inactive': 'Inactive','Master': 'Master','Standby': 'Standby'},
                'LockType':{
                  'Write': 'Write','Shared': 'Shared','VM': 'VM'},
                'SessionType':{
                  'Null': 'Null','WriteLock': 'WriteLock','Remote': 'Remote','Shared': 'Shared'},
                'DeviceType':{
                  'Null': 'Null','Floppy': 'Floppy','DVD': 'DVD','HardDisk': 'HardDisk','Network': 'Network','USB': 'USB','SharedFolder': 'SharedFolder'},
                'DeviceActivity':{
                  'Null': 'Null','Idle': 'Idle','Reading': 'Reading','Writing': 'Writing'},
                'ClipboardMode':{
                  'Disabled': 'Disabled','HostToGuest': 'HostToGuest','GuestToHost': 'GuestToHost','Bidirectional': 'Bidirectional'},
                'DragAndDropMode':{
                  'Disabled': 'Disabled','HostToGuest': 'HostToGuest','GuestToHost': 'GuestToHost','Bidirectional': 'Bidirectional'},
                'Scope':{
                  'Global': 'Global','Machine': 'Machine','Session': 'Session'},
                'BIOSBootMenuMode':{
                  'Disabled': 'Disabled','MenuOnly': 'MenuOnly','MessageAndMenu': 'MessageAndMenu'},
                'ProcessorFeature':{
                  'HWVirtEx': 'HWVirtEx','PAE': 'PAE','LongMode': 'LongMode','NestedPaging': 'NestedPaging'},
                'FirmwareType':{
                  'BIOS': 'BIOS','EFI': 'EFI','EFI32': 'EFI32','EFI64': 'EFI64','EFIDUAL': 'EFIDUAL'},
                'PointingHIDType':{
                  'None': 'None','PS2Mouse': 'PS2Mouse','USBMouse': 'USBMouse','USBTablet': 'USBTablet','ComboMouse': 'ComboMouse'},
                'KeyboardHIDType':{
                  'None': 'None','PS2Keyboard': 'PS2Keyboard','USBKeyboard': 'USBKeyboard','ComboKeyboard': 'ComboKeyboard'},
                'VFSType':{
                  'File': 'File','Cloud': 'Cloud','S3': 'S3','WebDav': 'WebDav'},
                'VFSFileType':{
                  'Unknown': 'Unknown','Fifo': 'Fifo','DevChar': 'DevChar','Directory': 'Directory','DevBlock': 'DevBlock','File': 'File','SymLink': 'SymLink','Socket': 'Socket','WhiteOut': 'WhiteOut'},
                'ImportOptions':{
                  'KeepAllMACs': 'KeepAllMACs','KeepNATMACs': 'KeepNATMACs'},
                'VirtualSystemDescriptionType':{
                  'Ignore': 'Ignore','OS': 'OS','Name': 'Name','Product': 'Product','Vendor': 'Vendor','Version': 'Version','ProductUrl': 'ProductUrl','VendorUrl': 'VendorUrl','Description': 'Description','License': 'License','Miscellaneous': 'Miscellaneous','CPU': 'CPU','Memory': 'Memory','HardDiskControllerIDE': 'HardDiskControllerIDE','HardDiskControllerSATA': 'HardDiskControllerSATA','HardDiskControllerSCSI': 'HardDiskControllerSCSI','HardDiskControllerSAS': 'HardDiskControllerSAS','HardDiskImage': 'HardDiskImage','Floppy': 'Floppy','CDROM': 'CDROM','NetworkAdapter': 'NetworkAdapter','USBController': 'USBController','SoundCard': 'SoundCard','SettingsFile': 'SettingsFile'},
                'VirtualSystemDescriptionValueType':{
                  'Reference': 'Reference','Original': 'Original','Auto': 'Auto','ExtraConfig': 'ExtraConfig'},
                'CleanupMode':{
                  'UnregisterOnly': 'UnregisterOnly','DetachAllReturnNone': 'DetachAllReturnNone','DetachAllReturnHardDisksOnly': 'DetachAllReturnHardDisksOnly','Full': 'Full'},
                'CloneMode':{
                  'MachineState': 'MachineState','MachineAndChildStates': 'MachineAndChildStates','AllStates': 'AllStates'},
                'CloneOptions':{
                  'Link': 'Link','KeepAllMACs': 'KeepAllMACs','KeepNATMACs': 'KeepNATMACs','KeepDiskNames': 'KeepDiskNames'},
                'AutostopType':{
                  'Disabled': 'Disabled','SaveState': 'SaveState','PowerOff': 'PowerOff','AcpiShutdown': 'AcpiShutdown'},
                'HostNetworkInterfaceMediumType':{
                  'Unknown': 'Unknown','Ethernet': 'Ethernet','PPP': 'PPP','SLIP': 'SLIP'},
                'HostNetworkInterfaceStatus':{
                  'Unknown': 'Unknown','Up': 'Up','Down': 'Down'},
                'HostNetworkInterfaceType':{
                  'Bridged': 'Bridged','HostOnly': 'HostOnly'},
                'AdditionsFacilityType':{
                  'None': 'None','VBoxGuestDriver': 'VBoxGuestDriver','AutoLogon': 'AutoLogon','VBoxService': 'VBoxService','VBoxTrayClient': 'VBoxTrayClient','Seamless': 'Seamless','Graphics': 'Graphics','All': 'All'},
                'AdditionsFacilityClass':{
                  'None': 'None','Driver': 'Driver','Service': 'Service','Program': 'Program','Feature': 'Feature','ThirdParty': 'ThirdParty','All': 'All'},
                'AdditionsFacilityStatus':{
                  'Inactive': 'Inactive','Paused': 'Paused','PreInit': 'PreInit','Init': 'Init','Active': 'Active','Terminating': 'Terminating','Terminated': 'Terminated','Failed': 'Failed','Unknown': 'Unknown'},
                'AdditionsRunLevelType':{
                  'None': 'None','System': 'System','Userland': 'Userland','Desktop': 'Desktop'},
                'AdditionsUpdateFlag':{
                  'None': 'None','WaitForUpdateStartOnly': 'WaitForUpdateStartOnly'},
                'FileSeekType':{
                  'Set': 'Set','Current': 'Current'},
                'ProcessInputFlag':{
                  'None': 'None','EndOfFile': 'EndOfFile'},
                'ProcessOutputFlag':{
                  'None': 'None','StdErr': 'StdErr'},
                'ProcessWaitForFlag':{
                  'None': 'None','Start': 'Start','Terminate': 'Terminate','StdIn': 'StdIn','StdOut': 'StdOut','StdErr': 'StdErr'},
                'ProcessWaitResult':{
                  'None': 'None','Start': 'Start','Terminate': 'Terminate','Status': 'Status','Error': 'Error','Timeout': 'Timeout','StdIn': 'StdIn','StdOut': 'StdOut','StdErr': 'StdErr','WaitFlagNotSupported': 'WaitFlagNotSupported'},
                'CopyFileFlag':{
                  'None': 'None','Recursive': 'Recursive','Update': 'Update','FollowLinks': 'FollowLinks'},
                'DirectoryCreateFlag':{
                  'None': 'None','Parents': 'Parents'},
                'DirectoryRemoveRecFlag':{
                  'None': 'None','ContentAndDir': 'ContentAndDir','ContentOnly': 'ContentOnly'},
                'PathRenameFlag':{
                  'None': 'None','NoReplace': 'NoReplace','Replace': 'Replace','NoSymlinks': 'NoSymlinks'},
                'ProcessCreateFlag':{
                  'None': 'None','WaitForProcessStartOnly': 'WaitForProcessStartOnly','IgnoreOrphanedProcesses': 'IgnoreOrphanedProcesses','Hidden': 'Hidden','NoProfile': 'NoProfile','WaitForStdOut': 'WaitForStdOut','WaitForStdErr': 'WaitForStdErr','ExpandArguments': 'ExpandArguments'},
                'ProcessPriority':{
                  'Invalid': 'Invalid','Default': 'Default'},
                'SymlinkType':{
                  'Unknown': 'Unknown','Directory': 'Directory','File': 'File'},
                'SymlinkReadFlag':{
                  'None': 'None','NoSymlinks': 'NoSymlinks'},
                'ProcessStatus':{
                  'Undefined': 'Undefined','Starting': 'Starting','Started': 'Started','Paused': 'Paused','Terminating': 'Terminating','TerminatedNormally': 'TerminatedNormally','TerminatedSignal': 'TerminatedSignal','TerminatedAbnormally': 'TerminatedAbnormally','TimedOutKilled': 'TimedOutKilled','TimedOutAbnormally': 'TimedOutAbnormally','Down': 'Down','Error': 'Error'},
                'FsObjType':{
                  'Undefined': 'Undefined','FIFO': 'FIFO','DevChar': 'DevChar','DevBlock': 'DevBlock','Directory': 'Directory','File': 'File','Symlink': 'Symlink','Socket': 'Socket','Whiteout': 'Whiteout'},
                'DragAndDropAction':{
                  'Ignore': 'Ignore','Copy': 'Copy','Move': 'Move','Link': 'Link'},
                'DirectoryOpenFlag':{
                  'None': 'None','NoSymlinks': 'NoSymlinks'},
                'MediumState':{
                  'NotCreated': 'NotCreated','Created': 'Created','LockedRead': 'LockedRead','LockedWrite': 'LockedWrite','Inaccessible': 'Inaccessible','Creating': 'Creating','Deleting': 'Deleting'},
                'MediumType':{
                  'Normal': 'Normal','Immutable': 'Immutable','Writethrough': 'Writethrough','Shareable': 'Shareable','Readonly': 'Readonly','MultiAttach': 'MultiAttach'},
                'MediumVariant':{
                  'Standard': 'Standard','VmdkSplit2G': 'VmdkSplit2G','VmdkRawDisk': 'VmdkRawDisk','VmdkStreamOptimized': 'VmdkStreamOptimized','VmdkESX': 'VmdkESX','Fixed': 'Fixed','Diff': 'Diff','NoCreateDir': 'NoCreateDir'},
                'DataType':{
                  'Int32': 'Int32','Int8': 'Int8','String': 'String'},
                'DataFlags':{
                  'None': 'None','Mandatory': 'Mandatory','Expert': 'Expert','Array': 'Array','FlagMask': 'FlagMask'},
                'MediumFormatCapabilities':{
                  'Uuid': 'Uuid','CreateFixed': 'CreateFixed','CreateDynamic': 'CreateDynamic','CreateSplit2G': 'CreateSplit2G','Differencing': 'Differencing','Asynchronous': 'Asynchronous','File': 'File','Properties': 'Properties','TcpNetworking': 'TcpNetworking','VFS': 'VFS','CapabilityMask': 'CapabilityMask'},
                'MouseButtonState':{
                  'LeftButton': 'LeftButton','RightButton': 'RightButton','MiddleButton': 'MiddleButton','WheelUp': 'WheelUp','WheelDown': 'WheelDown','XButton1': 'XButton1','XButton2': 'XButton2','MouseStateMask': 'MouseStateMask'},
                'FramebufferPixelFormat':{
                  'Opaque': 'Opaque','FOURCC_RGB': 'FOURCC_RGB'},
                'NetworkAttachmentType':{
                  'Null': 'Null','NAT': 'NAT','Bridged': 'Bridged','Internal': 'Internal','HostOnly': 'HostOnly','Generic': 'Generic'},
                'NetworkAdapterType':{
                  'Null': 'Null','Am79C970A': 'Am79C970A','Am79C973': 'Am79C973','I82540EM': 'I82540EM','I82543GC': 'I82543GC','I82545EM': 'I82545EM','Virtio': 'Virtio'},
                'NetworkAdapterPromiscModePolicy':{
                  'Deny': 'Deny','AllowNetwork': 'AllowNetwork','AllowAll': 'AllowAll'},
                'PortMode':{
                  'Disconnected': 'Disconnected','HostPipe': 'HostPipe','HostDevice': 'HostDevice','RawFile': 'RawFile'},
                'USBDeviceState':{
                  'NotSupported': 'NotSupported','Unavailable': 'Unavailable','Busy': 'Busy','Available': 'Available','Held': 'Held','Captured': 'Captured'},
                'USBDeviceFilterAction':{
                  'Null': 'Null','Ignore': 'Ignore','Hold': 'Hold'},
                'AudioDriverType':{
                  'Null': 'Null','WinMM': 'WinMM','OSS': 'OSS','ALSA': 'ALSA','DirectSound': 'DirectSound','CoreAudio': 'CoreAudio','MMPM': 'MMPM','Pulse': 'Pulse','SolAudio': 'SolAudio'},
                'AudioControllerType':{
                  'AC97': 'AC97','SB16': 'SB16','HDA': 'HDA'},
                'AuthType':{
                  'Null': 'Null','External': 'External','Guest': 'Guest'},
                'StorageBus':{
                  'Null': 'Null','IDE': 'IDE','SATA': 'SATA','SCSI': 'SCSI','Floppy': 'Floppy','SAS': 'SAS'},
                'StorageControllerType':{
                  'Null': 'Null','LsiLogic': 'LsiLogic','BusLogic': 'BusLogic','IntelAhci': 'IntelAhci','PIIX3': 'PIIX3','PIIX4': 'PIIX4','ICH6': 'ICH6','I82078': 'I82078','LsiLogicSas': 'LsiLogicSas'},
                'ChipsetType':{
                  'Null': 'Null','PIIX3': 'PIIX3','ICH9': 'ICH9'},
                'NATAliasMode':{
                  'AliasLog': 'AliasLog','AliasProxyOnly': 'AliasProxyOnly','AliasUseSamePorts': 'AliasUseSamePorts'},
                'NATProtocol':{
                  'UDP': 'UDP','TCP': 'TCP'},
                'BandwidthGroupType':{
                  'Null': 'Null','Disk': 'Disk','Network': 'Network'},
                'VBoxEventType':{
                  'Invalid': 'Invalid','Any': 'Any','Vetoable': 'Vetoable','MachineEvent': 'MachineEvent','SnapshotEvent': 'SnapshotEvent','InputEvent': 'InputEvent','LastWildcard': 'LastWildcard','OnMachineStateChanged': 'OnMachineStateChanged','OnMachineDataChanged': 'OnMachineDataChanged','OnExtraDataChanged': 'OnExtraDataChanged','OnExtraDataCanChange': 'OnExtraDataCanChange','OnMediumRegistered': 'OnMediumRegistered','OnMachineRegistered': 'OnMachineRegistered','OnSessionStateChanged': 'OnSessionStateChanged','OnSnapshotTaken': 'OnSnapshotTaken','OnSnapshotDeleted': 'OnSnapshotDeleted','OnSnapshotChanged': 'OnSnapshotChanged','OnGuestPropertyChanged': 'OnGuestPropertyChanged','OnMousePointerShapeChanged': 'OnMousePointerShapeChanged','OnMouseCapabilityChanged': 'OnMouseCapabilityChanged','OnKeyboardLedsChanged': 'OnKeyboardLedsChanged','OnStateChanged': 'OnStateChanged','OnAdditionsStateChanged': 'OnAdditionsStateChanged','OnNetworkAdapterChanged': 'OnNetworkAdapterChanged','OnSerialPortChanged': 'OnSerialPortChanged','OnParallelPortChanged': 'OnParallelPortChanged','OnStorageControllerChanged': 'OnStorageControllerChanged','OnMediumChanged': 'OnMediumChanged','OnVRDEServerChanged': 'OnVRDEServerChanged','OnUSBControllerChanged': 'OnUSBControllerChanged','OnUSBDeviceStateChanged': 'OnUSBDeviceStateChanged','OnSharedFolderChanged': 'OnSharedFolderChanged','OnRuntimeError': 'OnRuntimeError','OnCanShowWindow': 'OnCanShowWindow','OnShowWindow': 'OnShowWindow','OnCPUChanged': 'OnCPUChanged','OnVRDEServerInfoChanged': 'OnVRDEServerInfoChanged','OnEventSourceChanged': 'OnEventSourceChanged','OnCPUExecutionCapChanged': 'OnCPUExecutionCapChanged','OnGuestKeyboard': 'OnGuestKeyboard','OnGuestMouse': 'OnGuestMouse','OnNATRedirect': 'OnNATRedirect','OnHostPCIDevicePlug': 'OnHostPCIDevicePlug','OnVBoxSVCAvailabilityChanged': 'OnVBoxSVCAvailabilityChanged','OnBandwidthGroupChanged': 'OnBandwidthGroupChanged','OnGuestMonitorChanged': 'OnGuestMonitorChanged','OnStorageDeviceChanged': 'OnStorageDeviceChanged','OnClipboardModeChanged': 'OnClipboardModeChanged','OnDragAndDropModeChanged': 'OnDragAndDropModeChanged','Last': 'Last'},
                'GuestMonitorChangedEventType':{
                  'Enabled': 'Enabled','Disabled': 'Disabled','NewOrigin': 'NewOrigin'}}

   _ValuesFlat = {
                        'SettingsVersion_Null':0,
                        'SettingsVersion_v1_0':1,
                        'SettingsVersion_v1_1':2,
                        'SettingsVersion_v1_2':3,
                        'SettingsVersion_v1_3pre':4,
                        'SettingsVersion_v1_3':5,
                        'SettingsVersion_v1_4':6,
                        'SettingsVersion_v1_5':7,
                        'SettingsVersion_v1_6':8,
                        'SettingsVersion_v1_7':9,
                        'SettingsVersion_v1_8':10,
                        'SettingsVersion_v1_9':11,
                        'SettingsVersion_v1_10':12,
                        'SettingsVersion_v1_11':13,
                        'SettingsVersion_v1_12':14,
                        'SettingsVersion_v1_13':15,
                        'SettingsVersion_Future':99999,
                        'AccessMode_ReadOnly':1,
                        'AccessMode_ReadWrite':2,
                        'MachineState_Null':0,
                        'MachineState_PoweredOff':1,
                        'MachineState_Saved':2,
                        'MachineState_Teleported':3,
                        'MachineState_Aborted':4,
                        'MachineState_Running':5,
                        'MachineState_Paused':6,
                        'MachineState_Stuck':7,
                        'MachineState_Teleporting':8,
                        'MachineState_LiveSnapshotting':9,
                        'MachineState_Starting':10,
                        'MachineState_Stopping':11,
                        'MachineState_Saving':12,
                        'MachineState_Restoring':13,
                        'MachineState_TeleportingPausedVM':14,
                        'MachineState_TeleportingIn':15,
                        'MachineState_FaultTolerantSyncing':16,
                        'MachineState_DeletingSnapshotOnline':17,
                        'MachineState_DeletingSnapshotPaused':18,
                        'MachineState_RestoringSnapshot':19,
                        'MachineState_DeletingSnapshot':20,
                        'MachineState_SettingUp':21,
                        'MachineState_FirstOnline':5,
                        'MachineState_LastOnline':18,
                        'MachineState_FirstTransient':8,
                        'MachineState_LastTransient':21,
                        'SessionState_Null':0,
                        'SessionState_Unlocked':1,
                        'SessionState_Locked':2,
                        'SessionState_Spawning':3,
                        'SessionState_Unlocking':4,
                        'CPUPropertyType_Null':0,
                        'CPUPropertyType_PAE':1,
                        'CPUPropertyType_Synthetic':2,
                        'HWVirtExPropertyType_Null':0,
                        'HWVirtExPropertyType_Enabled':1,
                        'HWVirtExPropertyType_Exclusive':2,
                        'HWVirtExPropertyType_VPID':3,
                        'HWVirtExPropertyType_NestedPaging':4,
                        'HWVirtExPropertyType_LargePages':5,
                        'HWVirtExPropertyType_Force':6,
                        'FaultToleranceState_Inactive':1,
                        'FaultToleranceState_Master':2,
                        'FaultToleranceState_Standby':3,
                        'LockType_Write':2,
                        'LockType_Shared':1,
                        'LockType_VM':3,
                        'SessionType_Null':0,
                        'SessionType_WriteLock':1,
                        'SessionType_Remote':2,
                        'SessionType_Shared':3,
                        'DeviceType_Null':0,
                        'DeviceType_Floppy':1,
                        'DeviceType_DVD':2,
                        'DeviceType_HardDisk':3,
                        'DeviceType_Network':4,
                        'DeviceType_USB':5,
                        'DeviceType_SharedFolder':6,
                        'DeviceActivity_Null':0,
                        'DeviceActivity_Idle':1,
                        'DeviceActivity_Reading':2,
                        'DeviceActivity_Writing':3,
                        'ClipboardMode_Disabled':0,
                        'ClipboardMode_HostToGuest':1,
                        'ClipboardMode_GuestToHost':2,
                        'ClipboardMode_Bidirectional':3,
                        'DragAndDropMode_Disabled':0,
                        'DragAndDropMode_HostToGuest':1,
                        'DragAndDropMode_GuestToHost':2,
                        'DragAndDropMode_Bidirectional':3,
                        'Scope_Global':0,
                        'Scope_Machine':1,
                        'Scope_Session':2,
                        'BIOSBootMenuMode_Disabled':0,
                        'BIOSBootMenuMode_MenuOnly':1,
                        'BIOSBootMenuMode_MessageAndMenu':2,
                        'ProcessorFeature_HWVirtEx':0,
                        'ProcessorFeature_PAE':1,
                        'ProcessorFeature_LongMode':2,
                        'ProcessorFeature_NestedPaging':3,
                        'FirmwareType_BIOS':1,
                        'FirmwareType_EFI':2,
                        'FirmwareType_EFI32':3,
                        'FirmwareType_EFI64':4,
                        'FirmwareType_EFIDUAL':5,
                        'PointingHIDType_None':1,
                        'PointingHIDType_PS2Mouse':2,
                        'PointingHIDType_USBMouse':3,
                        'PointingHIDType_USBTablet':4,
                        'PointingHIDType_ComboMouse':5,
                        'KeyboardHIDType_None':1,
                        'KeyboardHIDType_PS2Keyboard':2,
                        'KeyboardHIDType_USBKeyboard':3,
                        'KeyboardHIDType_ComboKeyboard':4,
                        'VFSType_File':1,
                        'VFSType_Cloud':2,
                        'VFSType_S3':3,
                        'VFSType_WebDav':4,
                        'VFSFileType_Unknown':1,
                        'VFSFileType_Fifo':2,
                        'VFSFileType_DevChar':3,
                        'VFSFileType_Directory':4,
                        'VFSFileType_DevBlock':5,
                        'VFSFileType_File':6,
                        'VFSFileType_SymLink':7,
                        'VFSFileType_Socket':8,
                        'VFSFileType_WhiteOut':9,
                        'ImportOptions_KeepAllMACs':1,
                        'ImportOptions_KeepNATMACs':2,
                        'VirtualSystemDescriptionType_Ignore':1,
                        'VirtualSystemDescriptionType_OS':2,
                        'VirtualSystemDescriptionType_Name':3,
                        'VirtualSystemDescriptionType_Product':4,
                        'VirtualSystemDescriptionType_Vendor':5,
                        'VirtualSystemDescriptionType_Version':6,
                        'VirtualSystemDescriptionType_ProductUrl':7,
                        'VirtualSystemDescriptionType_VendorUrl':8,
                        'VirtualSystemDescriptionType_Description':9,
                        'VirtualSystemDescriptionType_License':10,
                        'VirtualSystemDescriptionType_Miscellaneous':11,
                        'VirtualSystemDescriptionType_CPU':12,
                        'VirtualSystemDescriptionType_Memory':13,
                        'VirtualSystemDescriptionType_HardDiskControllerIDE':14,
                        'VirtualSystemDescriptionType_HardDiskControllerSATA':15,
                        'VirtualSystemDescriptionType_HardDiskControllerSCSI':16,
                        'VirtualSystemDescriptionType_HardDiskControllerSAS':17,
                        'VirtualSystemDescriptionType_HardDiskImage':18,
                        'VirtualSystemDescriptionType_Floppy':19,
                        'VirtualSystemDescriptionType_CDROM':20,
                        'VirtualSystemDescriptionType_NetworkAdapter':21,
                        'VirtualSystemDescriptionType_USBController':22,
                        'VirtualSystemDescriptionType_SoundCard':23,
                        'VirtualSystemDescriptionType_SettingsFile':24,
                        'VirtualSystemDescriptionValueType_Reference':1,
                        'VirtualSystemDescriptionValueType_Original':2,
                        'VirtualSystemDescriptionValueType_Auto':3,
                        'VirtualSystemDescriptionValueType_ExtraConfig':4,
                        'CleanupMode_UnregisterOnly':1,
                        'CleanupMode_DetachAllReturnNone':2,
                        'CleanupMode_DetachAllReturnHardDisksOnly':3,
                        'CleanupMode_Full':4,
                        'CloneMode_MachineState':1,
                        'CloneMode_MachineAndChildStates':2,
                        'CloneMode_AllStates':3,
                        'CloneOptions_Link':1,
                        'CloneOptions_KeepAllMACs':2,
                        'CloneOptions_KeepNATMACs':3,
                        'CloneOptions_KeepDiskNames':4,
                        'AutostopType_Disabled':1,
                        'AutostopType_SaveState':2,
                        'AutostopType_PowerOff':3,
                        'AutostopType_AcpiShutdown':4,
                        'HostNetworkInterfaceMediumType_Unknown':0,
                        'HostNetworkInterfaceMediumType_Ethernet':1,
                        'HostNetworkInterfaceMediumType_PPP':2,
                        'HostNetworkInterfaceMediumType_SLIP':3,
                        'HostNetworkInterfaceStatus_Unknown':0,
                        'HostNetworkInterfaceStatus_Up':1,
                        'HostNetworkInterfaceStatus_Down':2,
                        'HostNetworkInterfaceType_Bridged':1,
                        'HostNetworkInterfaceType_HostOnly':2,
                        'AdditionsFacilityType_None':0,
                        'AdditionsFacilityType_VBoxGuestDriver':20,
                        'AdditionsFacilityType_AutoLogon':90,
                        'AdditionsFacilityType_VBoxService':100,
                        'AdditionsFacilityType_VBoxTrayClient':101,
                        'AdditionsFacilityType_Seamless':1000,
                        'AdditionsFacilityType_Graphics':1100,
                        'AdditionsFacilityType_All':2147483646,
                        'AdditionsFacilityClass_None':0,
                        'AdditionsFacilityClass_Driver':10,
                        'AdditionsFacilityClass_Service':30,
                        'AdditionsFacilityClass_Program':50,
                        'AdditionsFacilityClass_Feature':100,
                        'AdditionsFacilityClass_ThirdParty':999,
                        'AdditionsFacilityClass_All':2147483646,
                        'AdditionsFacilityStatus_Inactive':0,
                        'AdditionsFacilityStatus_Paused':1,
                        'AdditionsFacilityStatus_PreInit':20,
                        'AdditionsFacilityStatus_Init':30,
                        'AdditionsFacilityStatus_Active':50,
                        'AdditionsFacilityStatus_Terminating':100,
                        'AdditionsFacilityStatus_Terminated':101,
                        'AdditionsFacilityStatus_Failed':800,
                        'AdditionsFacilityStatus_Unknown':999,
                        'AdditionsRunLevelType_None':0,
                        'AdditionsRunLevelType_System':1,
                        'AdditionsRunLevelType_Userland':2,
                        'AdditionsRunLevelType_Desktop':3,
                        'AdditionsUpdateFlag_None':0,
                        'AdditionsUpdateFlag_WaitForUpdateStartOnly':1,
                        'FileSeekType_Set':0,
                        'FileSeekType_Current':1,
                        'ProcessInputFlag_None':0,
                        'ProcessInputFlag_EndOfFile':1,
                        'ProcessOutputFlag_None':0,
                        'ProcessOutputFlag_StdErr':1,
                        'ProcessWaitForFlag_None':0,
                        'ProcessWaitForFlag_Start':1,
                        'ProcessWaitForFlag_Terminate':2,
                        'ProcessWaitForFlag_StdIn':4,
                        'ProcessWaitForFlag_StdOut':8,
                        'ProcessWaitForFlag_StdErr':16,
                        'ProcessWaitResult_None':0,
                        'ProcessWaitResult_Start':1,
                        'ProcessWaitResult_Terminate':2,
                        'ProcessWaitResult_Status':3,
                        'ProcessWaitResult_Error':4,
                        'ProcessWaitResult_Timeout':5,
                        'ProcessWaitResult_StdIn':6,
                        'ProcessWaitResult_StdOut':7,
                        'ProcessWaitResult_StdErr':8,
                        'ProcessWaitResult_WaitFlagNotSupported':9,
                        'CopyFileFlag_None':0,
                        'CopyFileFlag_Recursive':1,
                        'CopyFileFlag_Update':2,
                        'CopyFileFlag_FollowLinks':4,
                        'DirectoryCreateFlag_None':0,
                        'DirectoryCreateFlag_Parents':1,
                        'DirectoryRemoveRecFlag_None':0,
                        'DirectoryRemoveRecFlag_ContentAndDir':1,
                        'DirectoryRemoveRecFlag_ContentOnly':2,
                        'PathRenameFlag_None':0,
                        'PathRenameFlag_NoReplace':1,
                        'PathRenameFlag_Replace':2,
                        'PathRenameFlag_NoSymlinks':4,
                        'ProcessCreateFlag_None':0,
                        'ProcessCreateFlag_WaitForProcessStartOnly':1,
                        'ProcessCreateFlag_IgnoreOrphanedProcesses':2,
                        'ProcessCreateFlag_Hidden':4,
                        'ProcessCreateFlag_NoProfile':8,
                        'ProcessCreateFlag_WaitForStdOut':16,
                        'ProcessCreateFlag_WaitForStdErr':32,
                        'ProcessCreateFlag_ExpandArguments':64,
                        'ProcessPriority_Invalid':0,
                        'ProcessPriority_Default':1,
                        'SymlinkType_Unknown':0,
                        'SymlinkType_Directory':1,
                        'SymlinkType_File':2,
                        'SymlinkReadFlag_None':0,
                        'SymlinkReadFlag_NoSymlinks':1,
                        'ProcessStatus_Undefined':0,
                        'ProcessStatus_Starting':10,
                        'ProcessStatus_Started':100,
                        'ProcessStatus_Paused':110,
                        'ProcessStatus_Terminating':480,
                        'ProcessStatus_TerminatedNormally':500,
                        'ProcessStatus_TerminatedSignal':510,
                        'ProcessStatus_TerminatedAbnormally':511,
                        'ProcessStatus_TimedOutKilled':512,
                        'ProcessStatus_TimedOutAbnormally':513,
                        'ProcessStatus_Down':600,
                        'ProcessStatus_Error':800,
                        'FsObjType_Undefined':0,
                        'FsObjType_FIFO':1,
                        'FsObjType_DevChar':10,
                        'FsObjType_DevBlock':11,
                        'FsObjType_Directory':50,
                        'FsObjType_File':80,
                        'FsObjType_Symlink':100,
                        'FsObjType_Socket':200,
                        'FsObjType_Whiteout':400,
                        'DragAndDropAction_Ignore':0,
                        'DragAndDropAction_Copy':1,
                        'DragAndDropAction_Move':2,
                        'DragAndDropAction_Link':3,
                        'DirectoryOpenFlag_None':0,
                        'DirectoryOpenFlag_NoSymlinks':1,
                        'MediumState_NotCreated':0,
                        'MediumState_Created':1,
                        'MediumState_LockedRead':2,
                        'MediumState_LockedWrite':3,
                        'MediumState_Inaccessible':4,
                        'MediumState_Creating':5,
                        'MediumState_Deleting':6,
                        'MediumType_Normal':0,
                        'MediumType_Immutable':1,
                        'MediumType_Writethrough':2,
                        'MediumType_Shareable':3,
                        'MediumType_Readonly':4,
                        'MediumType_MultiAttach':5,
                        'MediumVariant_Standard':0,
                        'MediumVariant_VmdkSplit2G':0x01,
                        'MediumVariant_VmdkRawDisk':0x02,
                        'MediumVariant_VmdkStreamOptimized':0x04,
                        'MediumVariant_VmdkESX':0x08,
                        'MediumVariant_Fixed':0x10000,
                        'MediumVariant_Diff':0x20000,
                        'MediumVariant_NoCreateDir':0x40000000,
                        'DataType_Int32':0,
                        'DataType_Int8':1,
                        'DataType_String':2,
                        'DataFlags_None':0x00,
                        'DataFlags_Mandatory':0x01,
                        'DataFlags_Expert':0x02,
                        'DataFlags_Array':0x04,
                        'DataFlags_FlagMask':0x07,
                        'MediumFormatCapabilities_Uuid':0x01,
                        'MediumFormatCapabilities_CreateFixed':0x02,
                        'MediumFormatCapabilities_CreateDynamic':0x04,
                        'MediumFormatCapabilities_CreateSplit2G':0x08,
                        'MediumFormatCapabilities_Differencing':0x10,
                        'MediumFormatCapabilities_Asynchronous':0x20,
                        'MediumFormatCapabilities_File':0x40,
                        'MediumFormatCapabilities_Properties':0x80,
                        'MediumFormatCapabilities_TcpNetworking':0x100,
                        'MediumFormatCapabilities_VFS':0x200,
                        'MediumFormatCapabilities_CapabilityMask':0x3FF,
                        'MouseButtonState_LeftButton':0x01,
                        'MouseButtonState_RightButton':0x02,
                        'MouseButtonState_MiddleButton':0x04,
                        'MouseButtonState_WheelUp':0x08,
                        'MouseButtonState_WheelDown':0x10,
                        'MouseButtonState_XButton1':0x20,
                        'MouseButtonState_XButton2':0x40,
                        'MouseButtonState_MouseStateMask':0x7F,
                        'FramebufferPixelFormat_Opaque':0,
                        'FramebufferPixelFormat_FOURCC_RGB':0x32424752,
                        'NetworkAttachmentType_Null':0,
                        'NetworkAttachmentType_NAT':1,
                        'NetworkAttachmentType_Bridged':2,
                        'NetworkAttachmentType_Internal':3,
                        'NetworkAttachmentType_HostOnly':4,
                        'NetworkAttachmentType_Generic':5,
                        'NetworkAdapterType_Null':0,
                        'NetworkAdapterType_Am79C970A':1,
                        'NetworkAdapterType_Am79C973':2,
                        'NetworkAdapterType_I82540EM':3,
                        'NetworkAdapterType_I82543GC':4,
                        'NetworkAdapterType_I82545EM':5,
                        'NetworkAdapterType_Virtio':6,
                        'NetworkAdapterPromiscModePolicy_Deny':1,
                        'NetworkAdapterPromiscModePolicy_AllowNetwork':2,
                        'NetworkAdapterPromiscModePolicy_AllowAll':3,
                        'PortMode_Disconnected':0,
                        'PortMode_HostPipe':1,
                        'PortMode_HostDevice':2,
                        'PortMode_RawFile':3,
                        'USBDeviceState_NotSupported':0,
                        'USBDeviceState_Unavailable':1,
                        'USBDeviceState_Busy':2,
                        'USBDeviceState_Available':3,
                        'USBDeviceState_Held':4,
                        'USBDeviceState_Captured':5,
                        'USBDeviceFilterAction_Null':0,
                        'USBDeviceFilterAction_Ignore':1,
                        'USBDeviceFilterAction_Hold':2,
                        'AudioDriverType_Null':0,
                        'AudioDriverType_WinMM':1,
                        'AudioDriverType_OSS':2,
                        'AudioDriverType_ALSA':3,
                        'AudioDriverType_DirectSound':4,
                        'AudioDriverType_CoreAudio':5,
                        'AudioDriverType_MMPM':6,
                        'AudioDriverType_Pulse':7,
                        'AudioDriverType_SolAudio':8,
                        'AudioControllerType_AC97':0,
                        'AudioControllerType_SB16':1,
                        'AudioControllerType_HDA':2,
                        'AuthType_Null':0,
                        'AuthType_External':1,
                        'AuthType_Guest':2,
                        'StorageBus_Null':0,
                        'StorageBus_IDE':1,
                        'StorageBus_SATA':2,
                        'StorageBus_SCSI':3,
                        'StorageBus_Floppy':4,
                        'StorageBus_SAS':5,
                        'StorageControllerType_Null':0,
                        'StorageControllerType_LsiLogic':1,
                        'StorageControllerType_BusLogic':2,
                        'StorageControllerType_IntelAhci':3,
                        'StorageControllerType_PIIX3':4,
                        'StorageControllerType_PIIX4':5,
                        'StorageControllerType_ICH6':6,
                        'StorageControllerType_I82078':7,
                        'StorageControllerType_LsiLogicSas':8,
                        'ChipsetType_Null':0,
                        'ChipsetType_PIIX3':1,
                        'ChipsetType_ICH9':2,
                        'NATAliasMode_AliasLog':0x1,
                        'NATAliasMode_AliasProxyOnly':0x02,
                        'NATAliasMode_AliasUseSamePorts':0x04,
                        'NATProtocol_UDP':0,
                        'NATProtocol_TCP':1,
                        'BandwidthGroupType_Null':0,
                        'BandwidthGroupType_Disk':1,
                        'BandwidthGroupType_Network':2,
                        'VBoxEventType_Invalid':0,
                        'VBoxEventType_Any':1,
                        'VBoxEventType_Vetoable':2,
                        'VBoxEventType_MachineEvent':3,
                        'VBoxEventType_SnapshotEvent':4,
                        'VBoxEventType_InputEvent':5,
                        'VBoxEventType_LastWildcard':31,
                        'VBoxEventType_OnMachineStateChanged':32,
                        'VBoxEventType_OnMachineDataChanged':33,
                        'VBoxEventType_OnExtraDataChanged':34,
                        'VBoxEventType_OnExtraDataCanChange':35,
                        'VBoxEventType_OnMediumRegistered':36,
                        'VBoxEventType_OnMachineRegistered':37,
                        'VBoxEventType_OnSessionStateChanged':38,
                        'VBoxEventType_OnSnapshotTaken':39,
                        'VBoxEventType_OnSnapshotDeleted':40,
                        'VBoxEventType_OnSnapshotChanged':41,
                        'VBoxEventType_OnGuestPropertyChanged':42,
                        'VBoxEventType_OnMousePointerShapeChanged':43,
                        'VBoxEventType_OnMouseCapabilityChanged':44,
                        'VBoxEventType_OnKeyboardLedsChanged':45,
                        'VBoxEventType_OnStateChanged':46,
                        'VBoxEventType_OnAdditionsStateChanged':47,
                        'VBoxEventType_OnNetworkAdapterChanged':48,
                        'VBoxEventType_OnSerialPortChanged':49,
                        'VBoxEventType_OnParallelPortChanged':50,
                        'VBoxEventType_OnStorageControllerChanged':51,
                        'VBoxEventType_OnMediumChanged':52,
                        'VBoxEventType_OnVRDEServerChanged':53,
                        'VBoxEventType_OnUSBControllerChanged':54,
                        'VBoxEventType_OnUSBDeviceStateChanged':55,
                        'VBoxEventType_OnSharedFolderChanged':56,
                        'VBoxEventType_OnRuntimeError':57,
                        'VBoxEventType_OnCanShowWindow':58,
                        'VBoxEventType_OnShowWindow':59,
                        'VBoxEventType_OnCPUChanged':60,
                        'VBoxEventType_OnVRDEServerInfoChanged':61,
                        'VBoxEventType_OnEventSourceChanged':62,
                        'VBoxEventType_OnCPUExecutionCapChanged':63,
                        'VBoxEventType_OnGuestKeyboard':64,
                        'VBoxEventType_OnGuestMouse':65,
                        'VBoxEventType_OnNATRedirect':66,
                        'VBoxEventType_OnHostPCIDevicePlug':67,
                        'VBoxEventType_OnVBoxSVCAvailabilityChanged':68,
                        'VBoxEventType_OnBandwidthGroupChanged':69,
                        'VBoxEventType_OnGuestMonitorChanged':70,
                        'VBoxEventType_OnStorageDeviceChanged':71,
                        'VBoxEventType_OnClipboardModeChanged':72,
                        'VBoxEventType_OnDragAndDropModeChanged':73,
                        'VBoxEventType_Last':74,
                        'GuestMonitorChangedEventType_Enabled':0,
                        'GuestMonitorChangedEventType_Disabled':1,
                        'GuestMonitorChangedEventType_NewOrigin':2}

   _ValuesFlatSym = {
                        'SettingsVersion_Null': 'Null',
                        'SettingsVersion_v1_0': 'v1_0',
                        'SettingsVersion_v1_1': 'v1_1',
                        'SettingsVersion_v1_2': 'v1_2',
                        'SettingsVersion_v1_3pre': 'v1_3pre',
                        'SettingsVersion_v1_3': 'v1_3',
                        'SettingsVersion_v1_4': 'v1_4',
                        'SettingsVersion_v1_5': 'v1_5',
                        'SettingsVersion_v1_6': 'v1_6',
                        'SettingsVersion_v1_7': 'v1_7',
                        'SettingsVersion_v1_8': 'v1_8',
                        'SettingsVersion_v1_9': 'v1_9',
                        'SettingsVersion_v1_10': 'v1_10',
                        'SettingsVersion_v1_11': 'v1_11',
                        'SettingsVersion_v1_12': 'v1_12',
                        'SettingsVersion_v1_13': 'v1_13',
                        'SettingsVersion_Future': 'Future',
                        'AccessMode_ReadOnly': 'ReadOnly',
                        'AccessMode_ReadWrite': 'ReadWrite',
                        'MachineState_Null': 'Null',
                        'MachineState_PoweredOff': 'PoweredOff',
                        'MachineState_Saved': 'Saved',
                        'MachineState_Teleported': 'Teleported',
                        'MachineState_Aborted': 'Aborted',
                        'MachineState_Running': 'Running',
                        'MachineState_Paused': 'Paused',
                        'MachineState_Stuck': 'Stuck',
                        'MachineState_Teleporting': 'Teleporting',
                        'MachineState_LiveSnapshotting': 'LiveSnapshotting',
                        'MachineState_Starting': 'Starting',
                        'MachineState_Stopping': 'Stopping',
                        'MachineState_Saving': 'Saving',
                        'MachineState_Restoring': 'Restoring',
                        'MachineState_TeleportingPausedVM': 'TeleportingPausedVM',
                        'MachineState_TeleportingIn': 'TeleportingIn',
                        'MachineState_FaultTolerantSyncing': 'FaultTolerantSyncing',
                        'MachineState_DeletingSnapshotOnline': 'DeletingSnapshotOnline',
                        'MachineState_DeletingSnapshotPaused': 'DeletingSnapshotPaused',
                        'MachineState_RestoringSnapshot': 'RestoringSnapshot',
                        'MachineState_DeletingSnapshot': 'DeletingSnapshot',
                        'MachineState_SettingUp': 'SettingUp',
                        'MachineState_FirstOnline': 'FirstOnline',
                        'MachineState_LastOnline': 'LastOnline',
                        'MachineState_FirstTransient': 'FirstTransient',
                        'MachineState_LastTransient': 'LastTransient',
                        'SessionState_Null': 'Null',
                        'SessionState_Unlocked': 'Unlocked',
                        'SessionState_Locked': 'Locked',
                        'SessionState_Spawning': 'Spawning',
                        'SessionState_Unlocking': 'Unlocking',
                        'CPUPropertyType_Null': 'Null',
                        'CPUPropertyType_PAE': 'PAE',
                        'CPUPropertyType_Synthetic': 'Synthetic',
                        'HWVirtExPropertyType_Null': 'Null',
                        'HWVirtExPropertyType_Enabled': 'Enabled',
                        'HWVirtExPropertyType_Exclusive': 'Exclusive',
                        'HWVirtExPropertyType_VPID': 'VPID',
                        'HWVirtExPropertyType_NestedPaging': 'NestedPaging',
                        'HWVirtExPropertyType_LargePages': 'LargePages',
                        'HWVirtExPropertyType_Force': 'Force',
                        'FaultToleranceState_Inactive': 'Inactive',
                        'FaultToleranceState_Master': 'Master',
                        'FaultToleranceState_Standby': 'Standby',
                        'LockType_Write': 'Write',
                        'LockType_Shared': 'Shared',
                        'LockType_VM': 'VM',
                        'SessionType_Null': 'Null',
                        'SessionType_WriteLock': 'WriteLock',
                        'SessionType_Remote': 'Remote',
                        'SessionType_Shared': 'Shared',
                        'DeviceType_Null': 'Null',
                        'DeviceType_Floppy': 'Floppy',
                        'DeviceType_DVD': 'DVD',
                        'DeviceType_HardDisk': 'HardDisk',
                        'DeviceType_Network': 'Network',
                        'DeviceType_USB': 'USB',
                        'DeviceType_SharedFolder': 'SharedFolder',
                        'DeviceActivity_Null': 'Null',
                        'DeviceActivity_Idle': 'Idle',
                        'DeviceActivity_Reading': 'Reading',
                        'DeviceActivity_Writing': 'Writing',
                        'ClipboardMode_Disabled': 'Disabled',
                        'ClipboardMode_HostToGuest': 'HostToGuest',
                        'ClipboardMode_GuestToHost': 'GuestToHost',
                        'ClipboardMode_Bidirectional': 'Bidirectional',
                        'DragAndDropMode_Disabled': 'Disabled',
                        'DragAndDropMode_HostToGuest': 'HostToGuest',
                        'DragAndDropMode_GuestToHost': 'GuestToHost',
                        'DragAndDropMode_Bidirectional': 'Bidirectional',
                        'Scope_Global': 'Global',
                        'Scope_Machine': 'Machine',
                        'Scope_Session': 'Session',
                        'BIOSBootMenuMode_Disabled': 'Disabled',
                        'BIOSBootMenuMode_MenuOnly': 'MenuOnly',
                        'BIOSBootMenuMode_MessageAndMenu': 'MessageAndMenu',
                        'ProcessorFeature_HWVirtEx': 'HWVirtEx',
                        'ProcessorFeature_PAE': 'PAE',
                        'ProcessorFeature_LongMode': 'LongMode',
                        'ProcessorFeature_NestedPaging': 'NestedPaging',
                        'FirmwareType_BIOS': 'BIOS',
                        'FirmwareType_EFI': 'EFI',
                        'FirmwareType_EFI32': 'EFI32',
                        'FirmwareType_EFI64': 'EFI64',
                        'FirmwareType_EFIDUAL': 'EFIDUAL',
                        'PointingHIDType_None': 'None',
                        'PointingHIDType_PS2Mouse': 'PS2Mouse',
                        'PointingHIDType_USBMouse': 'USBMouse',
                        'PointingHIDType_USBTablet': 'USBTablet',
                        'PointingHIDType_ComboMouse': 'ComboMouse',
                        'KeyboardHIDType_None': 'None',
                        'KeyboardHIDType_PS2Keyboard': 'PS2Keyboard',
                        'KeyboardHIDType_USBKeyboard': 'USBKeyboard',
                        'KeyboardHIDType_ComboKeyboard': 'ComboKeyboard',
                        'VFSType_File': 'File',
                        'VFSType_Cloud': 'Cloud',
                        'VFSType_S3': 'S3',
                        'VFSType_WebDav': 'WebDav',
                        'VFSFileType_Unknown': 'Unknown',
                        'VFSFileType_Fifo': 'Fifo',
                        'VFSFileType_DevChar': 'DevChar',
                        'VFSFileType_Directory': 'Directory',
                        'VFSFileType_DevBlock': 'DevBlock',
                        'VFSFileType_File': 'File',
                        'VFSFileType_SymLink': 'SymLink',
                        'VFSFileType_Socket': 'Socket',
                        'VFSFileType_WhiteOut': 'WhiteOut',
                        'ImportOptions_KeepAllMACs': 'KeepAllMACs',
                        'ImportOptions_KeepNATMACs': 'KeepNATMACs',
                        'VirtualSystemDescriptionType_Ignore': 'Ignore',
                        'VirtualSystemDescriptionType_OS': 'OS',
                        'VirtualSystemDescriptionType_Name': 'Name',
                        'VirtualSystemDescriptionType_Product': 'Product',
                        'VirtualSystemDescriptionType_Vendor': 'Vendor',
                        'VirtualSystemDescriptionType_Version': 'Version',
                        'VirtualSystemDescriptionType_ProductUrl': 'ProductUrl',
                        'VirtualSystemDescriptionType_VendorUrl': 'VendorUrl',
                        'VirtualSystemDescriptionType_Description': 'Description',
                        'VirtualSystemDescriptionType_License': 'License',
                        'VirtualSystemDescriptionType_Miscellaneous': 'Miscellaneous',
                        'VirtualSystemDescriptionType_CPU': 'CPU',
                        'VirtualSystemDescriptionType_Memory': 'Memory',
                        'VirtualSystemDescriptionType_HardDiskControllerIDE': 'HardDiskControllerIDE',
                        'VirtualSystemDescriptionType_HardDiskControllerSATA': 'HardDiskControllerSATA',
                        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 'HardDiskControllerSCSI',
                        'VirtualSystemDescriptionType_HardDiskControllerSAS': 'HardDiskControllerSAS',
                        'VirtualSystemDescriptionType_HardDiskImage': 'HardDiskImage',
                        'VirtualSystemDescriptionType_Floppy': 'Floppy',
                        'VirtualSystemDescriptionType_CDROM': 'CDROM',
                        'VirtualSystemDescriptionType_NetworkAdapter': 'NetworkAdapter',
                        'VirtualSystemDescriptionType_USBController': 'USBController',
                        'VirtualSystemDescriptionType_SoundCard': 'SoundCard',
                        'VirtualSystemDescriptionType_SettingsFile': 'SettingsFile',
                        'VirtualSystemDescriptionValueType_Reference': 'Reference',
                        'VirtualSystemDescriptionValueType_Original': 'Original',
                        'VirtualSystemDescriptionValueType_Auto': 'Auto',
                        'VirtualSystemDescriptionValueType_ExtraConfig': 'ExtraConfig',
                        'CleanupMode_UnregisterOnly': 'UnregisterOnly',
                        'CleanupMode_DetachAllReturnNone': 'DetachAllReturnNone',
                        'CleanupMode_DetachAllReturnHardDisksOnly': 'DetachAllReturnHardDisksOnly',
                        'CleanupMode_Full': 'Full',
                        'CloneMode_MachineState': 'MachineState',
                        'CloneMode_MachineAndChildStates': 'MachineAndChildStates',
                        'CloneMode_AllStates': 'AllStates',
                        'CloneOptions_Link': 'Link',
                        'CloneOptions_KeepAllMACs': 'KeepAllMACs',
                        'CloneOptions_KeepNATMACs': 'KeepNATMACs',
                        'CloneOptions_KeepDiskNames': 'KeepDiskNames',
                        'AutostopType_Disabled': 'Disabled',
                        'AutostopType_SaveState': 'SaveState',
                        'AutostopType_PowerOff': 'PowerOff',
                        'AutostopType_AcpiShutdown': 'AcpiShutdown',
                        'HostNetworkInterfaceMediumType_Unknown': 'Unknown',
                        'HostNetworkInterfaceMediumType_Ethernet': 'Ethernet',
                        'HostNetworkInterfaceMediumType_PPP': 'PPP',
                        'HostNetworkInterfaceMediumType_SLIP': 'SLIP',
                        'HostNetworkInterfaceStatus_Unknown': 'Unknown',
                        'HostNetworkInterfaceStatus_Up': 'Up',
                        'HostNetworkInterfaceStatus_Down': 'Down',
                        'HostNetworkInterfaceType_Bridged': 'Bridged',
                        'HostNetworkInterfaceType_HostOnly': 'HostOnly',
                        'AdditionsFacilityType_None': 'None',
                        'AdditionsFacilityType_VBoxGuestDriver': 'VBoxGuestDriver',
                        'AdditionsFacilityType_AutoLogon': 'AutoLogon',
                        'AdditionsFacilityType_VBoxService': 'VBoxService',
                        'AdditionsFacilityType_VBoxTrayClient': 'VBoxTrayClient',
                        'AdditionsFacilityType_Seamless': 'Seamless',
                        'AdditionsFacilityType_Graphics': 'Graphics',
                        'AdditionsFacilityType_All': 'All',
                        'AdditionsFacilityClass_None': 'None',
                        'AdditionsFacilityClass_Driver': 'Driver',
                        'AdditionsFacilityClass_Service': 'Service',
                        'AdditionsFacilityClass_Program': 'Program',
                        'AdditionsFacilityClass_Feature': 'Feature',
                        'AdditionsFacilityClass_ThirdParty': 'ThirdParty',
                        'AdditionsFacilityClass_All': 'All',
                        'AdditionsFacilityStatus_Inactive': 'Inactive',
                        'AdditionsFacilityStatus_Paused': 'Paused',
                        'AdditionsFacilityStatus_PreInit': 'PreInit',
                        'AdditionsFacilityStatus_Init': 'Init',
                        'AdditionsFacilityStatus_Active': 'Active',
                        'AdditionsFacilityStatus_Terminating': 'Terminating',
                        'AdditionsFacilityStatus_Terminated': 'Terminated',
                        'AdditionsFacilityStatus_Failed': 'Failed',
                        'AdditionsFacilityStatus_Unknown': 'Unknown',
                        'AdditionsRunLevelType_None': 'None',
                        'AdditionsRunLevelType_System': 'System',
                        'AdditionsRunLevelType_Userland': 'Userland',
                        'AdditionsRunLevelType_Desktop': 'Desktop',
                        'AdditionsUpdateFlag_None': 'None',
                        'AdditionsUpdateFlag_WaitForUpdateStartOnly': 'WaitForUpdateStartOnly',
                        'FileSeekType_Set': 'Set',
                        'FileSeekType_Current': 'Current',
                        'ProcessInputFlag_None': 'None',
                        'ProcessInputFlag_EndOfFile': 'EndOfFile',
                        'ProcessOutputFlag_None': 'None',
                        'ProcessOutputFlag_StdErr': 'StdErr',
                        'ProcessWaitForFlag_None': 'None',
                        'ProcessWaitForFlag_Start': 'Start',
                        'ProcessWaitForFlag_Terminate': 'Terminate',
                        'ProcessWaitForFlag_StdIn': 'StdIn',
                        'ProcessWaitForFlag_StdOut': 'StdOut',
                        'ProcessWaitForFlag_StdErr': 'StdErr',
                        'ProcessWaitResult_None': 'None',
                        'ProcessWaitResult_Start': 'Start',
                        'ProcessWaitResult_Terminate': 'Terminate',
                        'ProcessWaitResult_Status': 'Status',
                        'ProcessWaitResult_Error': 'Error',
                        'ProcessWaitResult_Timeout': 'Timeout',
                        'ProcessWaitResult_StdIn': 'StdIn',
                        'ProcessWaitResult_StdOut': 'StdOut',
                        'ProcessWaitResult_StdErr': 'StdErr',
                        'ProcessWaitResult_WaitFlagNotSupported': 'WaitFlagNotSupported',
                        'CopyFileFlag_None': 'None',
                        'CopyFileFlag_Recursive': 'Recursive',
                        'CopyFileFlag_Update': 'Update',
                        'CopyFileFlag_FollowLinks': 'FollowLinks',
                        'DirectoryCreateFlag_None': 'None',
                        'DirectoryCreateFlag_Parents': 'Parents',
                        'DirectoryRemoveRecFlag_None': 'None',
                        'DirectoryRemoveRecFlag_ContentAndDir': 'ContentAndDir',
                        'DirectoryRemoveRecFlag_ContentOnly': 'ContentOnly',
                        'PathRenameFlag_None': 'None',
                        'PathRenameFlag_NoReplace': 'NoReplace',
                        'PathRenameFlag_Replace': 'Replace',
                        'PathRenameFlag_NoSymlinks': 'NoSymlinks',
                        'ProcessCreateFlag_None': 'None',
                        'ProcessCreateFlag_WaitForProcessStartOnly': 'WaitForProcessStartOnly',
                        'ProcessCreateFlag_IgnoreOrphanedProcesses': 'IgnoreOrphanedProcesses',
                        'ProcessCreateFlag_Hidden': 'Hidden',
                        'ProcessCreateFlag_NoProfile': 'NoProfile',
                        'ProcessCreateFlag_WaitForStdOut': 'WaitForStdOut',
                        'ProcessCreateFlag_WaitForStdErr': 'WaitForStdErr',
                        'ProcessCreateFlag_ExpandArguments': 'ExpandArguments',
                        'ProcessPriority_Invalid': 'Invalid',
                        'ProcessPriority_Default': 'Default',
                        'SymlinkType_Unknown': 'Unknown',
                        'SymlinkType_Directory': 'Directory',
                        'SymlinkType_File': 'File',
                        'SymlinkReadFlag_None': 'None',
                        'SymlinkReadFlag_NoSymlinks': 'NoSymlinks',
                        'ProcessStatus_Undefined': 'Undefined',
                        'ProcessStatus_Starting': 'Starting',
                        'ProcessStatus_Started': 'Started',
                        'ProcessStatus_Paused': 'Paused',
                        'ProcessStatus_Terminating': 'Terminating',
                        'ProcessStatus_TerminatedNormally': 'TerminatedNormally',
                        'ProcessStatus_TerminatedSignal': 'TerminatedSignal',
                        'ProcessStatus_TerminatedAbnormally': 'TerminatedAbnormally',
                        'ProcessStatus_TimedOutKilled': 'TimedOutKilled',
                        'ProcessStatus_TimedOutAbnormally': 'TimedOutAbnormally',
                        'ProcessStatus_Down': 'Down',
                        'ProcessStatus_Error': 'Error',
                        'FsObjType_Undefined': 'Undefined',
                        'FsObjType_FIFO': 'FIFO',
                        'FsObjType_DevChar': 'DevChar',
                        'FsObjType_DevBlock': 'DevBlock',
                        'FsObjType_Directory': 'Directory',
                        'FsObjType_File': 'File',
                        'FsObjType_Symlink': 'Symlink',
                        'FsObjType_Socket': 'Socket',
                        'FsObjType_Whiteout': 'Whiteout',
                        'DragAndDropAction_Ignore': 'Ignore',
                        'DragAndDropAction_Copy': 'Copy',
                        'DragAndDropAction_Move': 'Move',
                        'DragAndDropAction_Link': 'Link',
                        'DirectoryOpenFlag_None': 'None',
                        'DirectoryOpenFlag_NoSymlinks': 'NoSymlinks',
                        'MediumState_NotCreated': 'NotCreated',
                        'MediumState_Created': 'Created',
                        'MediumState_LockedRead': 'LockedRead',
                        'MediumState_LockedWrite': 'LockedWrite',
                        'MediumState_Inaccessible': 'Inaccessible',
                        'MediumState_Creating': 'Creating',
                        'MediumState_Deleting': 'Deleting',
                        'MediumType_Normal': 'Normal',
                        'MediumType_Immutable': 'Immutable',
                        'MediumType_Writethrough': 'Writethrough',
                        'MediumType_Shareable': 'Shareable',
                        'MediumType_Readonly': 'Readonly',
                        'MediumType_MultiAttach': 'MultiAttach',
                        'MediumVariant_Standard': 'Standard',
                        'MediumVariant_VmdkSplit2G': 'VmdkSplit2G',
                        'MediumVariant_VmdkRawDisk': 'VmdkRawDisk',
                        'MediumVariant_VmdkStreamOptimized': 'VmdkStreamOptimized',
                        'MediumVariant_VmdkESX': 'VmdkESX',
                        'MediumVariant_Fixed': 'Fixed',
                        'MediumVariant_Diff': 'Diff',
                        'MediumVariant_NoCreateDir': 'NoCreateDir',
                        'DataType_Int32': 'Int32',
                        'DataType_Int8': 'Int8',
                        'DataType_String': 'String',
                        'DataFlags_None': 'None',
                        'DataFlags_Mandatory': 'Mandatory',
                        'DataFlags_Expert': 'Expert',
                        'DataFlags_Array': 'Array',
                        'DataFlags_FlagMask': 'FlagMask',
                        'MediumFormatCapabilities_Uuid': 'Uuid',
                        'MediumFormatCapabilities_CreateFixed': 'CreateFixed',
                        'MediumFormatCapabilities_CreateDynamic': 'CreateDynamic',
                        'MediumFormatCapabilities_CreateSplit2G': 'CreateSplit2G',
                        'MediumFormatCapabilities_Differencing': 'Differencing',
                        'MediumFormatCapabilities_Asynchronous': 'Asynchronous',
                        'MediumFormatCapabilities_File': 'File',
                        'MediumFormatCapabilities_Properties': 'Properties',
                        'MediumFormatCapabilities_TcpNetworking': 'TcpNetworking',
                        'MediumFormatCapabilities_VFS': 'VFS',
                        'MediumFormatCapabilities_CapabilityMask': 'CapabilityMask',
                        'MouseButtonState_LeftButton': 'LeftButton',
                        'MouseButtonState_RightButton': 'RightButton',
                        'MouseButtonState_MiddleButton': 'MiddleButton',
                        'MouseButtonState_WheelUp': 'WheelUp',
                        'MouseButtonState_WheelDown': 'WheelDown',
                        'MouseButtonState_XButton1': 'XButton1',
                        'MouseButtonState_XButton2': 'XButton2',
                        'MouseButtonState_MouseStateMask': 'MouseStateMask',
                        'FramebufferPixelFormat_Opaque': 'Opaque',
                        'FramebufferPixelFormat_FOURCC_RGB': 'FOURCC_RGB',
                        'NetworkAttachmentType_Null': 'Null',
                        'NetworkAttachmentType_NAT': 'NAT',
                        'NetworkAttachmentType_Bridged': 'Bridged',
                        'NetworkAttachmentType_Internal': 'Internal',
                        'NetworkAttachmentType_HostOnly': 'HostOnly',
                        'NetworkAttachmentType_Generic': 'Generic',
                        'NetworkAdapterType_Null': 'Null',
                        'NetworkAdapterType_Am79C970A': 'Am79C970A',
                        'NetworkAdapterType_Am79C973': 'Am79C973',
                        'NetworkAdapterType_I82540EM': 'I82540EM',
                        'NetworkAdapterType_I82543GC': 'I82543GC',
                        'NetworkAdapterType_I82545EM': 'I82545EM',
                        'NetworkAdapterType_Virtio': 'Virtio',
                        'NetworkAdapterPromiscModePolicy_Deny': 'Deny',
                        'NetworkAdapterPromiscModePolicy_AllowNetwork': 'AllowNetwork',
                        'NetworkAdapterPromiscModePolicy_AllowAll': 'AllowAll',
                        'PortMode_Disconnected': 'Disconnected',
                        'PortMode_HostPipe': 'HostPipe',
                        'PortMode_HostDevice': 'HostDevice',
                        'PortMode_RawFile': 'RawFile',
                        'USBDeviceState_NotSupported': 'NotSupported',
                        'USBDeviceState_Unavailable': 'Unavailable',
                        'USBDeviceState_Busy': 'Busy',
                        'USBDeviceState_Available': 'Available',
                        'USBDeviceState_Held': 'Held',
                        'USBDeviceState_Captured': 'Captured',
                        'USBDeviceFilterAction_Null': 'Null',
                        'USBDeviceFilterAction_Ignore': 'Ignore',
                        'USBDeviceFilterAction_Hold': 'Hold',
                        'AudioDriverType_Null': 'Null',
                        'AudioDriverType_WinMM': 'WinMM',
                        'AudioDriverType_OSS': 'OSS',
                        'AudioDriverType_ALSA': 'ALSA',
                        'AudioDriverType_DirectSound': 'DirectSound',
                        'AudioDriverType_CoreAudio': 'CoreAudio',
                        'AudioDriverType_MMPM': 'MMPM',
                        'AudioDriverType_Pulse': 'Pulse',
                        'AudioDriverType_SolAudio': 'SolAudio',
                        'AudioControllerType_AC97': 'AC97',
                        'AudioControllerType_SB16': 'SB16',
                        'AudioControllerType_HDA': 'HDA',
                        'AuthType_Null': 'Null',
                        'AuthType_External': 'External',
                        'AuthType_Guest': 'Guest',
                        'StorageBus_Null': 'Null',
                        'StorageBus_IDE': 'IDE',
                        'StorageBus_SATA': 'SATA',
                        'StorageBus_SCSI': 'SCSI',
                        'StorageBus_Floppy': 'Floppy',
                        'StorageBus_SAS': 'SAS',
                        'StorageControllerType_Null': 'Null',
                        'StorageControllerType_LsiLogic': 'LsiLogic',
                        'StorageControllerType_BusLogic': 'BusLogic',
                        'StorageControllerType_IntelAhci': 'IntelAhci',
                        'StorageControllerType_PIIX3': 'PIIX3',
                        'StorageControllerType_PIIX4': 'PIIX4',
                        'StorageControllerType_ICH6': 'ICH6',
                        'StorageControllerType_I82078': 'I82078',
                        'StorageControllerType_LsiLogicSas': 'LsiLogicSas',
                        'ChipsetType_Null': 'Null',
                        'ChipsetType_PIIX3': 'PIIX3',
                        'ChipsetType_ICH9': 'ICH9',
                        'NATAliasMode_AliasLog': 'AliasLog',
                        'NATAliasMode_AliasProxyOnly': 'AliasProxyOnly',
                        'NATAliasMode_AliasUseSamePorts': 'AliasUseSamePorts',
                        'NATProtocol_UDP': 'UDP',
                        'NATProtocol_TCP': 'TCP',
                        'BandwidthGroupType_Null': 'Null',
                        'BandwidthGroupType_Disk': 'Disk',
                        'BandwidthGroupType_Network': 'Network',
                        'VBoxEventType_Invalid': 'Invalid',
                        'VBoxEventType_Any': 'Any',
                        'VBoxEventType_Vetoable': 'Vetoable',
                        'VBoxEventType_MachineEvent': 'MachineEvent',
                        'VBoxEventType_SnapshotEvent': 'SnapshotEvent',
                        'VBoxEventType_InputEvent': 'InputEvent',
                        'VBoxEventType_LastWildcard': 'LastWildcard',
                        'VBoxEventType_OnMachineStateChanged': 'OnMachineStateChanged',
                        'VBoxEventType_OnMachineDataChanged': 'OnMachineDataChanged',
                        'VBoxEventType_OnExtraDataChanged': 'OnExtraDataChanged',
                        'VBoxEventType_OnExtraDataCanChange': 'OnExtraDataCanChange',
                        'VBoxEventType_OnMediumRegistered': 'OnMediumRegistered',
                        'VBoxEventType_OnMachineRegistered': 'OnMachineRegistered',
                        'VBoxEventType_OnSessionStateChanged': 'OnSessionStateChanged',
                        'VBoxEventType_OnSnapshotTaken': 'OnSnapshotTaken',
                        'VBoxEventType_OnSnapshotDeleted': 'OnSnapshotDeleted',
                        'VBoxEventType_OnSnapshotChanged': 'OnSnapshotChanged',
                        'VBoxEventType_OnGuestPropertyChanged': 'OnGuestPropertyChanged',
                        'VBoxEventType_OnMousePointerShapeChanged': 'OnMousePointerShapeChanged',
                        'VBoxEventType_OnMouseCapabilityChanged': 'OnMouseCapabilityChanged',
                        'VBoxEventType_OnKeyboardLedsChanged': 'OnKeyboardLedsChanged',
                        'VBoxEventType_OnStateChanged': 'OnStateChanged',
                        'VBoxEventType_OnAdditionsStateChanged': 'OnAdditionsStateChanged',
                        'VBoxEventType_OnNetworkAdapterChanged': 'OnNetworkAdapterChanged',
                        'VBoxEventType_OnSerialPortChanged': 'OnSerialPortChanged',
                        'VBoxEventType_OnParallelPortChanged': 'OnParallelPortChanged',
                        'VBoxEventType_OnStorageControllerChanged': 'OnStorageControllerChanged',
                        'VBoxEventType_OnMediumChanged': 'OnMediumChanged',
                        'VBoxEventType_OnVRDEServerChanged': 'OnVRDEServerChanged',
                        'VBoxEventType_OnUSBControllerChanged': 'OnUSBControllerChanged',
                        'VBoxEventType_OnUSBDeviceStateChanged': 'OnUSBDeviceStateChanged',
                        'VBoxEventType_OnSharedFolderChanged': 'OnSharedFolderChanged',
                        'VBoxEventType_OnRuntimeError': 'OnRuntimeError',
                        'VBoxEventType_OnCanShowWindow': 'OnCanShowWindow',
                        'VBoxEventType_OnShowWindow': 'OnShowWindow',
                        'VBoxEventType_OnCPUChanged': 'OnCPUChanged',
                        'VBoxEventType_OnVRDEServerInfoChanged': 'OnVRDEServerInfoChanged',
                        'VBoxEventType_OnEventSourceChanged': 'OnEventSourceChanged',
                        'VBoxEventType_OnCPUExecutionCapChanged': 'OnCPUExecutionCapChanged',
                        'VBoxEventType_OnGuestKeyboard': 'OnGuestKeyboard',
                        'VBoxEventType_OnGuestMouse': 'OnGuestMouse',
                        'VBoxEventType_OnNATRedirect': 'OnNATRedirect',
                        'VBoxEventType_OnHostPCIDevicePlug': 'OnHostPCIDevicePlug',
                        'VBoxEventType_OnVBoxSVCAvailabilityChanged': 'OnVBoxSVCAvailabilityChanged',
                        'VBoxEventType_OnBandwidthGroupChanged': 'OnBandwidthGroupChanged',
                        'VBoxEventType_OnGuestMonitorChanged': 'OnGuestMonitorChanged',
                        'VBoxEventType_OnStorageDeviceChanged': 'OnStorageDeviceChanged',
                        'VBoxEventType_OnClipboardModeChanged': 'OnClipboardModeChanged',
                        'VBoxEventType_OnDragAndDropModeChanged': 'OnDragAndDropModeChanged',
                        'VBoxEventType_Last': 'Last',
                        'GuestMonitorChangedEventType_Enabled': 'Enabled',
                        'GuestMonitorChangedEventType_Disabled': 'Disabled',
                        'GuestMonitorChangedEventType_NewOrigin': 'NewOrigin'}

   def __getattr__(self,attr):
      if self.isSym:
        v = self._ValuesFlatSym.get(attr)
      else:
        v = self._ValuesFlat.get(attr)
      if v is not None:
         return v
      else:
         raise AttributeError

   def all_values(self,enum_name):
      if self.isSym:
        vals = self._ValuesSym.get(enum_name)
      else:
        vals = self._Values.get(enum_name)
      if vals is not None:
         return vals
      else:
         return {}
