# vim:fileencoding=utf-8
# Copyright (c) 2008 gocept gmbh & co. kg
# See also LICENSE.txt
# $Id: setup.py 6873 2008-10-21 16:02:29Z mac $
"""Setup for country package.
"""

import os.path

from setuptools import setup, find_packages

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

setup(
    name='gocept.country',
    version='0.6.4',
    author='Sebastian Wehrmann, Christian Theune',
    author_email='sw@gocept.com',
    description='Zope 3 sources for pycountry databases',
    long_description = (read('README.txt')
                         + '\n\n' +
                         read('src', 'gocept', 'country',
                             'README.txt')
                         + '\n\n' +
                         read('CHANGES.txt')
    ),
    license='ZPL 2.1',
    keywords='country subdivision language currency iso 3166 639 4217 '
             '15924 3166-2 zope',
    zip_safe=False,
    namespace_packages = ['gocept'],
    classifiers = [
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Zope Public License',
        'Programming Language :: Python',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Topic :: Internet :: WWW/HTTP'],
    url='http://pypi.python.org/pypi/gocept.country/',
    packages=find_packages('src'),
    include_package_data=True,
    package_dir={'':'src'},
    install_requires=['setuptools',
                      'pycountry',
                      'zope.i18nmessageid',
                      'zc.sourcefactory>=0.3.3',
                      'zope.deferredimport',
    ],
    extras_require = dict(
        test=['zope.testing',
              'zope.app.testing',
              'zope.app.component',
              'zope.schema'])
    )
