#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["Trojan"]

from . import Malware

class Trojan(Malware):
    """
    Trojan Horse Detected.

    A trojan horse was detected. Trojan horses are malware that pretends to be
    legitimate software (and sometimes is) but in addition to that it contains
    a backdoor that allows an attacker to access the system subprepticiously.
    This is an indication of an earlier compromise by an unknown agent.
    """

    DEFAULTS = Malware.DEFAULTS.copy()
    DEFAULTS["cwe"] = "CWE-507"
    DEFAULTS["capec"] = "CAPEC-448"
    DEFAULTS["cvss_base"] = "9.3"
    DEFAULTS["references"] = (
        "https://en.wikipedia.org/wiki/Trojan_horse_(computing)",
    )
