#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["SourceCodeDisclosure"]

from .url_disclosure import UrlDisclosure

class SourceCodeDisclosure(UrlDisclosure):
    """
    Source Code Disclosure.

    A vulnerability was found in the web application or server that allows an
    attacker to download the source code of the web application.
    """

    DEFAULTS = UrlDisclosure.DEFAULTS.copy()
    DEFAULTS["level"] = "high"
    DEFAULTS["cwe"]   = "CWE-540"
    DEFAULTS["cvss_base"] = "6.8"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Information_Leakage",
        "http://www.acunetix.com/vulnerabilities/source-code-disclosure/",
        "https://www.imperva.com/resources/glossary/source_code_disclosure.html",
    )
