#!/usr/bin/python
# -*- coding: utf-8 -*-

__license__ = """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: http://golismero-project.com
Golismero project mail: golismero.project<@>gmail.com


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

from . import HTTPInjection


#------------------------------------------------------------------------------
class SQLInjection(HTTPInjection):
    """
    SQL Injection.

    SQL injection vulnerabilities allow an attacker to manipulate a SQL query
    made by the vulnerable web application. Depending on a variety of factors,
    risks may range from data corruption to complete compromise of the entire
    database, and even the server itself.

    The correct way to perform SQL queries is by using prepared statements.
    That way, the data and the code are transmitted in separate channels, with
    no possibility for injection. If using prepared statements is not possible,
    consider filtering special characters from the user input - however, this
    method cannot guarantee 100% effectiveness, and is heavily dependant on
    the specific configuration of the database being used.
    """

    DEFAULTS = HTTPInjection.DEFAULTS.copy()
    DEFAULTS["level"] = "critical"
    DEFAULTS["cwe"]   = "CWE-89"
    DEFAULTS["capec"] = ("CAPEC-66", "CAPEC-7")
    DEFAULTS["cvss_base"] = "7.5"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/SQL_Injection",
        "https://www.owasp.org/index.php/Blind_SQL_Injection",
        "https://www.owasp.org/index.php/Testing_for_SQL_Injection_(OWASP-DV-005)",
        "https://www.owasp.org/index.php/Reviewing_Code_for_SQL_Injection",
        "https://www.owasp.org/index.php/SQL_Injection_Prevention_Cheat_Sheet",
    )
