#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["DefacedUrl", "DefacedDomain", "DefacedIP"]

from . import Malware
from .. import UrlVulnerability, DomainVulnerability, IPVulnerability


#------------------------------------------------------------------------------
class DefacedUrl(UrlVulnerability):
    """
    Defaced URL Detected.

    A URL was found that has been reported as compromised and defaced.
    A defaced site is one where an attacker has replaced its contents
    in order to promote a certain political cause, publicly attack an
    opponent, or simply vandalize the target.

    While the consequences are mostly PR related, you should still review
    your website and ensure that your site was not compromised by a security
    intrusion.
    """

    DEFAULTS = Malware.DEFAULTS.copy()
    DEFAULTS["level"] = "low"
    DEFAULTS["cvss_base"] = "4.3"


#------------------------------------------------------------------------------
class DefacedDomain(DomainVulnerability):
    """
    Defaced Domain Detected.

    A domain was found that has been reported as compromised and defaced.
    A defaced site is one where an attacker has replaced its contents
    in order to promote a certain political cause, publicly attack an
    opponent, or simply vandalize the target.

    While the consequences are mostly PR related, you should still review
    your website and ensure that your site was not compromised by a security
    intrusion.
    """

    DEFAULTS = Malware.DEFAULTS.copy()
    DEFAULTS["level"] = "low"
    DEFAULTS["cvss_base"] = "5.8"

#------------------------------------------------------------------------------
class DefacedIP(IPVulnerability):
    """
    Defaced IP Detected.

    An IP was found that has been reported as compromised and defaced.
    A defaced site is one where an attacker has replaced its contents
    in order to promote a certain political cause, publicly attack an
    opponent, or simply vandalize the target.

    While the consequences are mostly PR related, you should still review
    your website and ensure that your site was not compromised by a security
    intrusion.
    """

    DEFAULTS = Malware.DEFAULTS.copy()
    DEFAULTS["level"] = "low"
    DEFAULTS["cvss_base"] = "6.6"