#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["MissingSecureFlag"]

from . import CookieVulnerability

class MissingSecureFlag(CookieVulnerability):
    """
    Missing "Secure" Flag.

    A cookie without the "Secure" flag was found. A strategically located
    attacker may be able to eavesdrop on the network and capture the contents
    of this cookie.

    Always set the "Secure" flag on cookies that should only be transmitted
    over an encrypted channel.
    """

    DEFAULTS = CookieVulnerability.DEFAULTS.copy()
    DEFAULTS["cwe"]   = "CWE-614"
    DEFAULTS["capec"] = "CAPEC-102"
    DEFAULTS["cvss_base"] = "4"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/SecureFlag",
        "https://www.owasp.org/index.php/Testing_for_cookies_attributes_(OWASP-SM-002)",
    )
