#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

from .. import Vulnerability


#------------------------------------------------------------------------------
class OutdatedPlatform(Vulnerability):
    "" # this is intentional, do not remove or change!

    DEFAULTS = Vulnerability.DEFAULTS.copy()
    DEFAULTS["level"] = "high"
    DEFAULTS["cvss_base"] = "9"
    DEFAULTS["description"] = \
        "An outdated, potentially vulnerable platform was found."
    DEFAULTS["solution"] = \
"""If possible, apply all missing patches or upgrade to a newer version.
If not, consider adding firewall rules to restrict access to these hosts."""
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Top_10_2013-A5-Security_Misconfiguration",
    )


#------------------------------------------------------------------------------
class OutdatedPlatformMandriva(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/mandriva"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Mandriva"


#------------------------------------------------------------------------------
class OutdatedPlatformWindows(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/windows"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Windows"


#------------------------------------------------------------------------------
class OutdatedPlatformDebian(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/debian"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Debian"


#------------------------------------------------------------------------------
class OutdatedPlatformMacOSX(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/mac_os_x"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Mac OS X"


#------------------------------------------------------------------------------
class OutdatedPlatformVMwareESX(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/vmware_esx"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: VMware ESX"


#------------------------------------------------------------------------------
class OutdatedPlatformUbuntu(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/ubuntu"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Ubuntu"


#------------------------------------------------------------------------------
class OutdatedPlatformHPUX(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/hp_ux"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: HP-UX"


#------------------------------------------------------------------------------
class OutdatedPlatformSuSE(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/suse"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: SuSE"


#------------------------------------------------------------------------------
class OutdatedPlatformFreeBSD(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/freebsd"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: FreeBSD"


#------------------------------------------------------------------------------
class OutdatedPlatformJunos(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/junos"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: JunOS"


#------------------------------------------------------------------------------
class OutdatedPlatformScientificLinux(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/sci_linux"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Scientific Linux"


#------------------------------------------------------------------------------
class OutdatedPlatformSlackware(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/slackware"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Slackware"


#------------------------------------------------------------------------------
class OutdatedPlatformSolaris(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/solaris"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Solaris"


#------------------------------------------------------------------------------
class OutdatedPlatformRedHat(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/redhat"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Red Hat"


#------------------------------------------------------------------------------
class OutdatedPlatformAmazonLinux(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/amazon"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Amazon Linux"


#------------------------------------------------------------------------------
class OutdatedPlatformAIX(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/aix"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: AIX"


#------------------------------------------------------------------------------
class OutdatedPlatformGentoo(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/gentoo"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Gentoo"


#------------------------------------------------------------------------------
class OutdatedPlatformCentOS(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/centos"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: CentOS"


#------------------------------------------------------------------------------
class OutdatedPlatformOracleLinux(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/oracle"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Oracle Linux"


#------------------------------------------------------------------------------
class OutdatedPlatformFedora(OutdatedPlatform):
    vulnerability_type = OutdatedPlatform.vulnerability_type + "/fedora"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Fedora"


#------------------------------------------------------------------------------
__all__ = [ x for x in dir() if x.startswith("OutdatedPlatform") ]
