#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__ = """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["DNSPoisoning"]

from ..information_disclosure.domain_disclosure import DomainDisclosure


#------------------------------------------------------------------------------
class DNSPoisoning(DomainDisclosure):
    """
    DNS Poisoning.

    The domain could possibly be affected by malware that causes DNS poisoning.
    DNS spoofing (or DNS cache poisoning) is a computer hacking attack, whereby
    data is introduced into a Domain Name System (DNS) name server's cache
    database, causing the name server to return an incorrect IP address,
    diverting traffic to another computer (often the attacker's).

    You should review your server and your communications with your ISP and
    ensure that your site was not compromised by a security intrusion.
    """

    DEFAULTS = DomainDisclosure.DEFAULTS.copy()
    DEFAULTS["level"] = "middle"
    DEFAULTS["severity"] = 2
    DEFAULTS["risk"] = 2
    DEFAULTS["capec"] = ("CAPEC-142", "CAPEC-163", "CAPEC-187", "CAPEC-275")
    DEFAULTS["cvss_base"] = "5.8"
    DEFAULTS["references"] = (
        "http://en.wikipedia.org/wiki/DNS_spoofing",
    )
