#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Web shell detected.
"""

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["WebShell"]

from . import Malware

class WebShell(Malware):
    """
    Web Shell Detected.

    A web shell is a malicious web application that allows an attacker to take
    control of the server in which it runs. This is an indication of an earlier
    compromise by an unknown agent.
    """

    DEFAULTS = Malware.DEFAULTS.copy()
    DEFAULTS["capec"] = "CAPEC-442"
    DEFAULTS["cvss_base"] = "9.3"
    DEFAULTS["references"] = (
        "https://en.wikipedia.org/wiki/Backdoor_Shell",
        "https://www.owasp.org/images/c/c3/ASDC12-Old_Webshells_New_Tricks_How_Persistent_Threats_haverevived_an_old_idea_and_how_you_can_detect_them.pdf",
    )
