#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["InsecureAlgorithm"]

from . import SSLVulnerability
from ... import identity


#------------------------------------------------------------------------------
class InsecureAlgorithm(SSLVulnerability):
    """
    Insecure SSL/TLS Algorithm.

    An SSL/TLS certificate was found to be using an insecure algorithm. This
    may allow a strategically located attacker to snoop on network traffic, or
    perform a Man-In-The-Middle attack against unsuspecting users connecting
    to this host.

    Create a new certificate using only secure algorithms.
    """

    DEFAULTS = SSLVulnerability.DEFAULTS.copy()
    DEFAULTS["cwe"] = "CWE-327"
    DEFAULTS["cvss_base"] = "4"


    #--------------------------------------------------------------------------
    def __init__(self, domain, algorithms, **kwargs):
        """
        :param domain: Domain where the vulnerability was found.
        :type domain: Domain

        :param algorithms: Vulnerable algorithm names.
        :type algorithms: tuple(str...)

        """

        # Sanitize the arguments.
        if isinstance(algorithms, basestring):
            algorithms = (algorithms,)
        else:
            algorithms = tuple(algorithms)
            for x in algorithms:
                if not isinstance(x, basestring):
                    raise TypeError(
                        "Expected string, got %r instead" % type(x))

        # Algorithm names.
        self.__algorithms = algorithms

        # Parent constructor.
        super(InsecureAlgorithm, self).__init__(domain, **kwargs)

    __init__.__doc__ += SSLVulnerability.__init__.__doc__


    #--------------------------------------------------------------------------
    @identity
    def algorithms(self):
        """
        :returns: Vulnerable algorithm names.
        :rtype: tuple(str...)
        """
        return self.__algorithms
