#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2013

Authors:
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: https://github.com/golismero
Golismero project mail: golismero.project<@>gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["InvalidCommonName"]

from . import SSLVulnerability
from ... import identity


#------------------------------------------------------------------------------
class InvalidCommonName(SSLVulnerability):
    """
    Invalid CN Field.

    An invalid CN field was found in a SSL/TLS certificate. This may allow a
    strategically located attacker to snoop on network traffic, or perform a
    Man-In-The-Middle attack against unsuspecting users connecting to this
    host.

    Create a new certificate with the correct CN field.
    """

    DEFAULTS = SSLVulnerability.DEFAULTS.copy()
    DEFAULTS["cwe"] = "CWE-327"
    DEFAULTS["cvss_base"] = "4"

    #--------------------------------------------------------------------------
    def __init__(self, domain, common_name, **kwargs):
        """
        :param domain: Domain where the vulnerability was found.
        :type domain: Domain

        :param common_name: Common name (CN).
        :type common_name: str

        """

        # Common name.
        self.__common_name = common_name

        # Parent constructor.
        super(InvalidCommonName, self).__init__(domain, **kwargs)

    __init__.__doc__ += SSLVulnerability.__init__.__doc__


    #--------------------------------------------------------------------------
    @identity
    def common_name(self):
        """
        :returns: Common name (CN).
        :rtype: str
        """
        return self.__common_name
