# Copyright (C) 2012 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

__author__ = 'afshar@google.com (Ali Afshar)'

import os
import pydoc

from drivecli.commands import base


class LogCommand(base.BaseCommand):
  """View the entire protocol log in a pager."""

  name = 'log'

  def Execute(self, d, opts):
    f = open(os.path.expanduser('~/.drivecli.log'))
    text = f.read()
    f.close()
    pydoc.pager(text)
