# Copyright (C) 2012 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

__author__ = 'afshar@google.com (Ali Afshar)'

from drivecli import drivelib
from drivecli.commands import base


class PermissionsCommand(base.BaseCommand):
  """List permissions on a file."""

  name = 'permissions'

  def Configure(self, parser):
    parser.add_argument('file')

  def Execute(self, d, opts):
    r = drivelib._Permissions(d, fileId=opts.file)
    if r == drivelib.Error:
      print r.status
    else:
      for p in r['items']:
        print  '{0} [{1}, {2}]'.format(p['name'], p['role'], p['type'])
      return r
