#! /usr/bin/python
#
# googlecalc.py

# Released Under the MIT License
# Copyright (c) 2007 Calvin Spealman
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

__all__ = ['googlecalc']

import sys
from urllib import quote_plus
from urllib2 import build_opener
from BeautifulSoup import BeautifulSoup
from decimal import Decimal

opener = build_opener()
opener.addheaders = [('User-agent', 'Mozilla/5.0')]

def googlecalc(query):
    try:
        resultpage = BeautifulSoup(
                     opener.open("http://www.google.com/search?q=%s" %
                                 quote_plus(query)).read()
                 )
        
        resultstring = resultpage.body.findAll('font',size='+1')[0].b
        resultstring = ''.join(substring for substring in resultstring if isinstance(substring, basestring))
        resultstring = resultstring.split('=')[1].strip()

        parts = resultstring.split(' ', 1)
        if len(parts) == 1:
            unittype = ''
        else:
            unittype = parts[-1]

        return Decimal(''.join(parts[:1])), unittype

    except IndexError:
        raise ValueError("Bad Query.")


if __name__ == '__main__':
    try:
        print "%s %s" % googlecalc(' '.join(sys.argv[1:]))
    except ValueError, e:
        print e.args[0]
        sys.exit(1)

