# This file is part of gorm, an object relational mapper for versioned graphs.
# Copyright (C) 2014 Zachary Spector.
ctbranch = "SELECT COUNT(*) FROM branches WHERE branch=?;"
ctgraph = "SELECT COUNT(*) FROM graphs WHERE graph=?;"
ctglobal = "SELECT COUNT(*) FROM global;"
global_items = "SELECT key, value FROM global;"
allbranch = "SELECT branch, parent, parent_rev FROM branches;"
global_get = "SELECT value FROM global WHERE key=?;"
new_graph = "INSERT INTO graphs (graph, type) VALUES (?, ?);"
graph_type = "SELECT type FROM graphs WHERE graph=?;"
new_branch = (
    "INSERT INTO branches (branch, parent, parent_rev) "
    "VALUES (?, ?, ?);"
)
del_edge_val_graph = "DELETE FROM edge_val WHERE graph=?;"
del_edge_graph = "DELETE FROM edges WHERE graph=?;"
del_node_val_graph = "DELETE FROM node_val WHERE graph=?;"
del_node_graph = "DELETE FROM nodes WHERE graph=?;"
del_graph = "DELETE FROM graphs WHERE graph=?;"
parrev = "SELECT parent_rev FROM branches WHERE branch=?;"
parparrev = "SELECT parent, parent_rev FROM branches WHERE branch=?;"
global_ins = "INSERT INTO global (key, value) VALUES (?, ?);"
global_upd = "UPDATE global SET value=? WHERE key=?;"
global_del = "DELETE FROM global WHERE key=?;"
nodes_extant = (
    "SELECT nodes.node "
    "FROM nodes JOIN ("
    "SELECT graph, node, branch, MAX(rev) AS rev FROM nodes "
    "WHERE graph=? "
    "AND branch=? "
    "AND rev<=? "
    "GROUP BY graph, node, branch) AS hirev "
    "ON nodes.graph=hirev.graph "
    "AND nodes.node=hirev.node "
    "AND nodes.branch=hirev.branch "
    "AND nodes.rev=hirev.rev "
    "WHERE nodes.node IS NOT NULL "
    "AND nodes.extant;"
)
node_exists = (
    "SELECT nodes.extant FROM nodes JOIN ("
    "SELECT graph, node, branch, MAX(rev) AS rev FROM nodes "
    "WHERE graph=? "
    "AND node=? "
    "AND branch=? "
    "AND rev<=? "
    "GROUP BY graph, node, branch) AS hirev "
    "ON nodes.graph=hirev.graph "
    "AND nodes.node=hirev.node "
    "AND nodes.branch=hirev.branch "
    "AND nodes.rev=hirev.rev;"
)
graph_val_items = (
    "SELECT graph_val.key, graph_val.value "
    "FROM graph_val JOIN ("
    "SELECT graph, key, branch, MAX(rev) AS rev FROM graph_val "
    "WHERE graph=? "
    "AND branch=? "
    "AND rev<=? "
    "GROUP BY graph, key, branch) AS hirev "
    "ON graph_val.graph=hirev.graph "
    "AND graph_val.key=hirev.key "
    "AND graph_val.branch=hirev.branch "
    "AND graph_val.rev=hirev.rev;"
)
graph_val_get = (
    "SELECT value FROM graph_val JOIN ("
    "SELECT graph, key, branch, MAX(rev) AS rev "
    "FROM graph_val WHERE "
    "graph=? AND "
    "key=? AND "
    "branch=? AND "
    "rev<=? GROUP BY graph, key, branch) AS hirev "
    "ON graph_val.graph=hirev.graph "
    "AND graph_val.key=hirev.key "
    "AND graph_val.branch=hirev.branch "
    "AND graph_val.rev=hirev.rev;"
)
graph_val_ins = (
    "INSERT INTO graph_val ("
    "graph, "
    "key, "
    "branch, "
    "rev, "
    "value) VALUES (?, ?, ?, ?, ?);"
)
graph_val_upd = (
    "UPDATE graph_val SET value=? "
    "WHERE graph=? "
    "AND key=? "
    "AND branch=? "
    "AND rev=?;"
)
exist_node_ins = (
    "INSERT INTO nodes ("
    "graph, "
    "node, "
    "branch, "
    "rev, "
    "extant) VALUES (?, ?, ?, ?, ?);"
)
exist_node_upd = (
    "UPDATE nodes SET extant=? "
    "WHERE graph=? "
    "AND node=? "
    "AND branch=? "
    "AND rev=?;"
)
node_val_items = (
    "SELECT node_val.key, node_val.value FROM node_val JOIN ("
    "SELECT graph, node, key, branch, MAX(rev) AS rev "
    "FROM node_val WHERE "
    "graph=? AND "
    "node=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, node, key, branch) AS hirev ON "
    "node_val.graph=hirev.graph AND "
    "node_val.node=hirev.node AND "
    "node_val.key=hirev.key AND "
    "node_val.branch=hirev.branch AND "
    "node_val.rev=hirev.rev;"
)
node_val_get = (
    "SELECT node_val.value FROM node_val JOIN ("
    "SELECT graph, node, key, branch, MAX(rev) AS rev "
    "FROM node_val WHERE "
    "graph=? AND "
    "node=? AND "
    "key=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, node, key, branch) AS hirev "
    "ON node_val.graph=hirev.graph "
    "AND node_val.node=hirev.node "
    "AND node_val.key=hirev.key "
    "AND node_val.branch=hirev.branch "
    "AND node_val.rev=hirev.rev "
    "WHERE node_val.value IS NOT NULL;"
)
node_val_ins = (
    "INSERT INTO node_val ("
    "graph, "
    "node, "
    "key, "
    "branch, "
    "rev, "
    "value) VALUES "
    "(?, ?, ?, ?, ?, ?);"
)
node_val_upd = (
    "UPDATE node_val SET value=? WHERE "
    "graph=? AND "
    "node=? AND "
    "key=? AND "
    "branch=? AND "
    "rev=?;"
)
node_val_compare = (
    "SELECT before.key, before.value, after.value FROM "
    "(SELECT key, value, FROM node_val JOIN ("
    "SELECT graph, node, key, branch, MAX(rev) "
    "AS rev FROM node_val "
    "WHERE graph=? "
    "AND node=? "
    "AND branch=? "
    "AND rev<=? GROUP BY graph, node, key, branch) AS hirev1 "
    "ON node_val.graph=hirev1.graph "
    "AND node_val.node=hirev1.node "
    "AND node_val.key=hirev1.key "
    "AND node_val.branch=hirev1.branch "
    "AND node_val.rev=hirev1.rev"
    ") AS before FULL JOIN "
    "(SELECT key, value FROM node_val JOIN ("
    "SELECT graph, node, key, branch, "
    "MAX(rev) AS rev FROM node_val "
    "WHERE graph=? "
    "AND node=? "
    "AND branch=? "
    "AND rev<=? GROUP BY graph, node, key, branch) AS hirev2 "
    "ON node_val.graph=hirev2.graph "
    "AND node_val.node=hirev2.node "
    "AND node_val.key=hirev2.key "
    "AND node_val.branch=hirev2.branch "
    "AND node_val.rev=hirev2.rev"
    ") AS after "
    "ON before.key=after.key "
    "WHERE before.value<>after.value"
    ";"
)
edge_exists = (
    "SELECT edges.extant FROM edges JOIN ("
    "SELECT graph, nodeA, nodeB, idx, branch, "
    "MAX(rev) AS rev FROM edges "
    "WHERE graph=? "
    "AND nodeA=? "
    "AND nodeB=? "
    "AND idx=? "
    "AND branch=? "
    "AND rev<=? "
    "GROUP BY graph, nodeA, nodeB, idx, branch) AS hirev "
    "ON edges.graph=hirev.graph "
    "AND edges.nodeA=hirev.nodeA "
    "AND edges.nodeB=hirev.nodeB "
    "AND edges.idx=hirev.idx "
    "AND edges.branch=hirev.branch "
    "AND edges.rev=hirev.rev;"
)
edge_exist_ins = (
    "INSERT INTO edges ("
    "graph, "
    "nodeA, "
    "nodeB, "
    "idx, "
    "branch, "
    "rev, "
    "extant) VALUES (?, ?, ?, ?, ?, ?, ?);"
)
edge_exist_upd = (
    "UPDATE edges SET extant=? WHERE "
    "graph=? AND "
    "nodeA=? AND "
    "nodeB=? AND "
    "idx=? AND "
    "branch=? AND "
    "rev=?;"
)
edge_val_items = (
    "SELECT edge_val.key FROM edge_val JOIN ("
    "SELECT graph, nodeA, nodeB, idx, key, branch, "
    "MAX(rev) AS rev "
    "FROM edge_val WHERE "
    "graph=? AND "
    "nodeA=? AND "
    "nodeB=? AND "
    "idx=? AND "
    "branch=? AND "
    "rev<=? GROUP BY graph, nodeA, nodeB, idx, key, branch) "
    "AS hirev "
    "ON edge_val.graph=hirev.graph "
    "AND edge_val.nodeA=hirev.nodeA "
    "AND edge_val.nodeB=hirev.nodeB "
    "AND edge_val.idx=hirev.idx "
    "AND edge_val.rev=hirev.rev "
    "WHERE edge_val.value IS NOT NULL;"
)
edge_val_get = (
    "SELECT edge_val.value FROM edge_val JOIN ("
    "SELECT graph, nodeA, nodeB, idx, key, branch, "
    "MAX(rev) AS rev "
    "FROM edge_val WHERE "
    "graph=? AND "
    "nodeA=? AND "
    "nodeB=? AND "
    "idx=? AND "
    "key=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, nodeA, nodeB, idx, key, branch) AS hirev "
    "ON edge_val.graph=hirev.graph "
    "AND edge_val.nodeA=hirev.nodeA "
    "AND edge_val.nodeB=hirev.nodeB "
    "AND edge_val.idx=hirev.idx "
    "AND edge_val.key=hirev.key "
    "AND edge_val.branch=hirev.branch "
    "AND edge_val.rev=hirev.rev "
    ";"
)
edge_val_ins = (
    "INSERT INTO edge_val ("
    "graph, "
    "nodeA, "
    "nodeB, "
    "idx, "
    "key, "
    "branch, "
    "rev, "
    "value) VALUES "
    "(?, ?, ?, ?, ?, ?, ?, ?);"
)
edge_val_upd = (
    "UPDATE edge_val SET value=? "
    "WHERE graph=? "
    "AND nodeA=? "
    "AND nodeB=? "
    "AND idx=? "
    "AND key=? "
    "AND branch=? "
    "AND rev=?;"
)
edges_extant = (
    "SELECT edges.nodeA, edges.extant FROM edges JOIN "
    "(SELECT graph, nodeA, nodeB, idx, branch, MAX(rev) AS rev "
    "FROM edges WHERE "
    "graph=? AND "
    "branch=? AND "
    "rev<=? GROUP BY "
    "graph, nodeA, nodeB, idx, branch) AS hirev ON "
    "edges.graph=hirev.graph AND "
    "edges.nodeA=hirev.nodeA AND "
    "edges.nodeB=hirev.nodeB AND "
    "edges.idx=hirev.idx AND "
    "edges.branch=hirev.branch AND "
    "edges.rev=hirev.rev;"
)
nodeBs = (
    "SELECT edges.nodeB, edges.extant FROM edges JOIN ("
    "SELECT graph, nodeA, nodeB, branch, MAX(rev) AS rev "
    "FROM edges WHERE "
    "graph=? AND "
    "nodeA=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, nodeA, nodeB, branch) "
    "AS hirev ON "
    "edges.graph=hirev.graph AND "
    "edges.nodeA=hirev.nodeA AND "
    "edges.nodeB=hirev.nodeB AND "
    "edges.branch=hirev.branch AND "
    "edges.rev=hirev.rev;"
)
nodeAs = (
    "SELECT edges.nodeA, edges.extant FROM edges JOIN ("
    "SELECT graph, nodeA, nodeB, idx, branch, MAX(rev) AS rev "
    "FROM edges WHERE "
    "graph=? AND "
    "nodeB=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, nodeA, nodeB, idx, branch "
    ") AS hirev ON "
    "edges.graph=hirev.graph AND "
    "edges.nodeA=hirev.nodeA AND "
    "edges.nodeB=hirev.nodeB AND "
    "edges.idx=hirev.idx AND "
    "edges.branch=hirev.branch AND "
    "edges.rev=hirev.rev;"
)
edge_exists = (
    "SELECT edges.extant FROM edges JOIN "
    "(SELECT graph, nodeA, nodeB, idx, branch, "
    "MAX(rev) AS rev FROM edges WHERE "
    "graph=? AND "
    "nodeA=? AND "
    "nodeB=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, nodeA, nodeB, idx, branch"
    ") AS hirev ON "
    "edges.graph=hirev.graph AND "
    "edges.nodeA=hirev.nodeA AND "
    "edges.nodeB=hirev.nodeB AND "
    "edges.idx=hirev.idx AND "
    "edges.branch=hirev.branch AND "
    "edges.rev=hirev.rev;"
)
multi_edges = (
    "SELECT edges.idx, edges.extant FROM edges JOIN ("
    "SELECT graph, nodeA, nodeB, idx, branch, MAX(rev) AS rev "
    "FROM edges WHERE "
    "graph=? AND "
    "nodeA=? AND "
    "nodeB=? AND "
    "branch=? AND "
    "rev<=? "
    "GROUP BY graph, nodeA, nodeB, idx, branch) AS hirev ON "
    "edges.graph=hirev.graph AND "
    "edges.nodeA=hirev.nodeA AND "
    "edges.nodeB=hirev.nodeB AND "
    "edges.idx=hirev.idx AND "
    "edges.branch=hirev.branch AND "
    "edges.rev=hirev.rev"
    ";"
)
