# -*- coding: utf-8 -*-
# 得用gevent来执行，否则会被一个命令卡住

from gevent import monkey; monkey.patch_all()
from gevent import wsgi

import argparse
import uuid
import json
import socket
from flask import Flask, Response
from flask import request, current_app, stream_with_context

DEBUG = True
TERMINATOR = '\r\n'

GOURD_HTTP_DEFAULT_HOST = '127.0.0.1'
GOURD_HTTP_DEFAULT_PORT = 5505

GOURD_SERVER_HOST = '127.0.0.1'
GOURD_SERVER_PORT = 5500

app = Flask(__name__)
app.config.from_object(__name__)

# id 2 socket
socket_map = dict()


@app.route('/call/<remote_endpoint>')
def remote_call(remote_endpoint):
    """
    保持链接，有数据就返回
    """
    unique_id = uuid.uuid1().hex

    send_dict = request.args.to_dict()
    send_dict['endpoint'] = remote_endpoint

    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.connect((app.config['GOURD_SERVER_HOST'], app.config['GOURD_SERVER_PORT']))

    sock.send(json.dumps(send_dict)+current_app.config['TERMINATOR'])

    socket_map[unique_id] = sock

    def generate():
        yield '<pre>unique_id: %s</pre>' % unique_id

        while True:
            recv_data = sock.recv(4096)
            current_app.logger.debug('recv_data: %s', recv_data)
            if not recv_data:
                yield '<pre>gourd server closed</pre>'
                if unique_id in socket_map:
                    socket_map.pop(unique_id).close()
                break
            else:
                yield '<pre>%s</pre>' % recv_data

    return Response(stream_with_context(generate()))


@app.route('/close/<unique_id>')
def close_conn(unique_id):
    sock = socket_map.pop(unique_id, None)

    if not sock:
        return 'sock not in socket_map'
    else:
        sock.close()
        return 'sock closed'


@app.route('/stat')
def stat():
    stat_dict = dict([(k, v.fileno()) for k, v in socket_map.items()])
    return '<pre>%s</pre>' % json.dumps(stat_dict, indent=4)


def build_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--host', default=app.config['GOURD_HTTP_DEFAULT_HOST'], help='bind host', action='store')
    parser.add_argument('-p', '--port', default=app.config['GOURD_HTTP_DEFAULT_PORT'], type=int, help='bind port', action='store')
    parser.add_argument('-a', '--ghost', default=app.config['GOURD_SERVER_HOST'], help='gourd host', action='store')
    parser.add_argument('-b', '--gport', default=app.config['GOURD_SERVER_PORT'], type=int, help='gourd port', action='store')
    return parser


def main():
    args = build_parser().parse_args()
    app.config['GOURD_SERVER_HOST'] = args.ghost
    app.config['GOURD_SERVER_PORT'] = args.gport

    print "* Running gserver on http://%s:%s" % (args.host, args.port)
    wsgi.WSGIServer((args.host, int(args.port)), app).serve_forever()


if __name__ == '__main__':
    main()

