#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import argparse
import uuid
import json
import socket
from flask import Flask, Response
from flask import request, current_app, stream_with_context

DEBUG = False
TERMINATOR = '\n'

GOURD_HTTP_DEFAULT_HOST = '127.0.0.1'
GOURD_HTTP_DEFAULT_PORT = 5505

GOURD_SERVER_HOST = '127.0.0.1'
GOURD_SERVER_PORT = 5500

app = Flask(__name__)
app.config.from_object(__name__)

# id 2 socket
socket_map = dict()


def make_rsp(rsp):
    format_tpl = u'\n/' + u'-' * 80 + u'\n%s\n' + u'-' * 80 + u'/\n'

    if isinstance(rsp, dict):
        rsp = json.dumps(rsp, indent=4, ensure_ascii=False)

    return format_tpl % rsp

@app.route('/call/<remote_endpoint>')
def remote_call(remote_endpoint):
    """
    保持链接，有数据就返回
    """
    unique_id = uuid.uuid1().hex

    send_dict = request.args.to_dict()
    send_dict['endpoint'] = remote_endpoint

    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sock.connect((app.config['GOURD_SERVER_HOST'], app.config['GOURD_SERVER_PORT']))
    except Exception, e:
        return make_rsp('connect to gourd server fail. e: %s' % e)

    try:
        sock.send(json.dumps(send_dict)+current_app.config['TERMINATOR'])
    except Exception, e:
        return make_rsp('send to gourd server fail. e: %s' % e)

    socket_map[unique_id] = sock

    def generate():
        yield make_rsp('unique_id: %s' % unique_id)

        while True:
            f = sock.makefile('rw')
            recv_data = f.readline()
            if not recv_data:
                current_app.logger.debug('gourd server closed socket')
                yield make_rsp('gourd server closed socket')
                if unique_id in socket_map:
                    socket_map.pop(unique_id).close()
                break
            else:
                current_app.logger.debug('recv_data: %s', recv_data)
                try:
                    jdata = json.loads(recv_data)
                    yield make_rsp(jdata)
                except Exception, e:
                    current_app.logger.error('json.loads(recv_data) fail: %s', e)
                    yield make_rsp(recv_data)

    return Response(stream_with_context(generate()))


@app.route('/close/<unique_id>')
def close_conn(unique_id):
    sock = socket_map.pop(unique_id, None)

    if not sock:
        return make_rsp('sock not in socket_map')
    else:
        sock.close()
        return make_rsp('sock succ closed')


@app.route('/stat')
def stat():
    stat_dict = dict([(k, v.fileno()) for k, v in socket_map.items()])
    return make_rsp(stat_dict)


def build_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--host', default=app.config['GOURD_HTTP_DEFAULT_HOST'], help='bind host', action='store')
    parser.add_argument('-p', '--port', default=app.config['GOURD_HTTP_DEFAULT_PORT'], type=int, help='bind port', action='store')
    parser.add_argument('-a', '--ghost', default=app.config['GOURD_SERVER_HOST'], help='gourd host', action='store')
    parser.add_argument('-b', '--gport', default=app.config['GOURD_SERVER_PORT'], type=int, help='gourd port', action='store')
    parser.add_argument('-d', '--debug', default=False, help='debug mode', action='store_true')
    return parser


def main():
    # 得用gevent来执行，否则会被一个命令卡住
    from gevent import monkey; monkey.patch_all()
    from gevent import wsgi

    args = build_parser().parse_args()
    app.debug = args.debug
    app.config['GOURD_SERVER_HOST'] = args.ghost
    app.config['GOURD_SERVER_PORT'] = args.gport

    app.logger.info("* Running gourd_http on http://%s:%s, gourd is %s:%s, debug:%s" % (
        args.host, args.port, args.ghost, args.gport, args.debug
    ))
    try:
        wsgi.WSGIServer((args.host, int(args.port)), app).serve_forever()
    except KeyboardInterrupt:
        sys.exit(0)


if __name__ == '__main__':
    main()

